#======================================================================
import numpy as np
import math
import matplotlib.pyplot as plt
#import matplotlib as plt
from matplotlib import rc
#import csv
#====================Plotting ==========================================
import matplotlib.pyplot as plt

from matplotlib import rc

rc('text',usetex=True)
font = {'size'   : 15}
rc('font', **font)
#
color=['b','k','r','g','k','gray','orange','c','#f781bf']
#
f1=np.loadtxt('./Prcl/Sim1/r_mean.dat')
f2=np.loadtxt('./Prcl/Sim2/r_mean.dat')
f3=np.loadtxt('./Observation/Sim1/r_mean.dat')
f4=np.loadtxt('./Observation/Sim2/r_mean.dat')
#
f11=np.loadtxt('./Prcl/Sim1/r_Num_Con.dat')
f12=np.loadtxt('./Prcl/Sim2/r_Num_Con.dat')
f13=np.loadtxt('./Observation/Sim1/r_Num_Con.dat')
f14=np.loadtxt('./Observation/Sim2/r_Num_Con.dat')
#
f21=np.loadtxt('./Prcl/Sim1/r_stand_div.dat')
f22=np.loadtxt('./Prcl/Sim2/r_stand_div.dat')
f23=np.loadtxt('./Observation/Sim1/r_stand_div.dat')
f24=np.loadtxt('./Observation/Sim2/r_stand_div.dat')
#
f89=np.loadtxt('./Bera_Data/Obs/Hgt_r_NC_Std.dat')
f99=np.loadtxt('./Bera_Data/Prcl/Hgt_r_NC_Std.dat')
#
fig, (ax1, ax2, ax3) = plt.subplots(1, 3, figsize= (10,3))
Np1 = 100000
######################################################
ax1.plot(f1[:,2] ,f1[:,1]/Np1, color = color[2],lw=1,label='Prcl-Sim1')
ax1.plot(f3[:,2] ,f3[:,1]/Np1, color = color[3],lw=1,label='Obsn-Sim1')
ax1.plot(f2[:,2] ,f2[:,1]/Np1, color = color[4],lw=1,label='Prcl-Sim2')
ax1.plot(f4[:,2] ,f4[:,1]/Np1, color = color[6],lw=1,label='Obsn-Sim2')
ax1.plot(f89[:,1],f89[:,0], color = color[7], marker = 'o',label='Obsn-SB')
ax1.plot(f99[:,1],f99[:,0], color = color[8], marker = '*',label='Prcl-SB')
ax1.set_xlabel(r"$r_m($ $\mu$m)",fontsize=10)
ax1.set_ylabel(r'H(km)',fontsize=12)
#ax1.legend(loc='upper left',prop={'size':9.5},frameon=False)
ax1.set_title("Mean Radius")
ax1.set_xlim([0,30])
ax1.set_ylim([0.1,1.3])
ax1.set_xticks([0,5,10,15,20,25,30])#, -0.1, 0, 0.1, 0.2])
ax1.set_yticks([0.1,0.3,0.5,0.7,0.9,1.1,1.3])
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
Np = (25.6*25.6*25.6)
ax2.plot(f11[:,2]/Np ,f11[:,1]/Np1,color=color[2],lw=1,label='Prcl-Sim1')
ax2.plot(f13[:,2]/Np ,f13[:,1]/Np1,color=color[3],lw=1,label='Obsn-Sim1')
ax2.plot(f12[:,2]/Np ,f12[:,1]/Np1,color=color[4],lw=1,label='Prcl-Sim2')
ax2.plot(f14[:,2] ,f14[:,1]/Np1,color=color[6],lw=1,label='Obsn-Sim2')
ax2.plot(f89[:,2] ,f89[:,0],color=color[7], marker = 'o',label='Obsn-SB')
ax2.plot(f99[:,2] ,f99[:,0],color=color[8], marker = '*',label='Prcl-SB')
ax2.set_xlabel(r"NC(/cc)",fontsize=10)
ax2.set_ylabel(r'H(km)',fontsize=12)
ax2.set_title("Number Concentration")
#ax2.legend(loc='lower right',prop={'size':9.5},frameon=False)
ax2.set_xlim([0,400])
ax2.set_ylim([0.1,1.3])
ax2.set_xticks([0,100,200,300,400])#, -0.1, 0, 0.1, 0.2])
ax2.set_yticks([0.1,0.3,0.5,0.7,0.9,1.1,1.3])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
ax3.plot(f21[:,2] ,f21[:,1]/Np1,color=color[2],lw=1,label='DNS-PS1')
ax3.plot(f23[:,2] ,f23[:,1]/Np1,color=color[3],lw=1,label='DNS-OS1')
ax3.plot(f22[:,2] ,f22[:,1]/Np1,color=color[4],lw=1,label='DNS-PS2')
ax3.plot(f24[:,2] ,f24[:,1]/Np1,color=color[6],lw=1,label='DNS-OS2')
ax3.plot(f89[:,3] ,f89[:,0],color=color[7], marker = 'o',label='Obsn')
ax3.plot(f99[:,3] ,f99[:,0],color=color[8], marker = '*',label='Prcl')
ax3.set_xlabel(r"$S_d$",fontsize=10)
ax3.set_ylabel(r'H(km)',fontsize=12)
ax3.set_title("Standerd Deviation")
#ax3.legend(loc='upper left',prop={'size':9.5},frameon=False)
ax3.set_xlim([0,10])
ax3.set_ylim([0.1,1.3])
ax3.set_xticks([0,2,4,6,8,10])#, -0.1, 0, 0.1, 0.2])
ax3.set_yticks([0.1,0.3,0.5,0.7,0.9,1.1,1.3])
ax3.xaxis.set_tick_params(labelsize=11)
ax3.yaxis.set_tick_params(labelsize=11)
ax3.grid()
#
plt.legend(bbox_to_anchor=(1.08,1.08), loc='upper left', borderaxespad=0.)
plt.tight_layout()
plt.savefig('Droplet_Physics_SB.png', dpi=300)
plt.show()
plt.close()
########## Time vs Number Concentration ####################################
f1=np.loadtxt('./Prcl/Sim1/r_Num_Con.dat')
f2=np.loadtxt('./Prcl/Sim2/r_Num_Con.dat')
f3=np.loadtxt('./Observation/Sim1/r_Num_Con.dat')
f4=np.loadtxt('./Observation/Sim2/r_Num_Con.dat')

fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f1[:,0] ,f1[:,1]/(25.6*25.6*25.6),color=color[2],lw=1,label='Prcl')
ax1.plot(f3[:,0] ,f3[:,1]/(25.6*25.6*25.6),color=color[3],lw=1,label='Obsn')
ax1.set_ylabel(r"NC(/cc)",fontsize=10)
ax1.set_xlabel(r't(sec)',fontsize=12)
ax1.set_title("Simulation-1")
ax1.legend(loc='lower right',prop={'size':9.5},frameon=False)
ax1.set_xlim([0,200])
ax1.set_ylim([100,400])
ax1.set_xticks([0,25,50,75,100,125,150,175,200])#, -0.1, 0, 0.1, 0.2])
ax1.set_yticks([100,150,200,250,300,350,400])
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f2[:,0] ,f2[:,2],color=color[2],lw=1,label='Prcl')
ax2.plot(f4[:,0] ,f4[:,2],color=color[3],lw=1,label='Obsn')
#ax2.set_ylabel(r"$r_m($ $\mu$m)",fontsize=10)
ax2.set_xlabel(r't(sec)',fontsize=12)
ax2.set_title("Simulation-2")
ax2.legend(loc='upper right',prop={'size':9.5},frameon=False)
ax2.set_xlim([0,200])
ax2.set_ylim([0,400])
ax2.set_xticks([0,25,50,75,100,125,150,175,200])#, -0.1, 0, 0.1, 0.2])
ax2.set_yticks([0,50,100,150,200,250,300,350,400])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.tight_layout()
#plt.savefig('NC_SB.png', dpi=300)
#plt.show()
#plt.close()
########## Time vs Standerd Deviation##################################
f1=np.loadtxt('./Prcl/Sim1/r_stand_div.dat')
f2=np.loadtxt('./Prcl/Sim2/r_stand_div.dat')
f3=np.loadtxt('./Observation/Sim1/r_stand_div.dat')
f4=np.loadtxt('./Observation/Sim2/r_stand_div.dat')

fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f1[:,0] ,f1[:,1],color=color[2],lw=1,label='Prcl')
ax1.plot(f3[:,0] ,f3[:,1],color=color[3],lw=1,label='Obsn')
ax1.set_ylabel(r"$S_d$",fontsize=10)
ax1.set_xlabel(r't(sec)',fontsize=12)
ax1.set_title("Simulation-1")
ax1.legend(loc='upper left',prop={'size':9.5},frameon=False)
ax1.set_xlim([0,200])
ax1.set_ylim([0,6])
ax1.set_xticks([0,25,50,75,100,125,150,175,200])#, -0.1, 0, 0.1, 0.2])
#ax1.set_yticks([0,2,4,6,8,10,12])
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f2[:,0] ,f2[:,1],color=color[2],lw=1,label='Prcl')
ax2.plot(f4[:,0] ,f4[:,1],color=color[3],lw=1,label='Obsn')
#ax2.set_ylabel(r"$r_m($ $\mu$m)",fontsize=10)
ax2.set_xlabel(r't(sec)',fontsize=12)
ax2.set_title("Simulation-2")
ax2.legend(loc='upper left',prop={'size':9.5},frameon=False)
ax2.set_xlim([0,200])
ax2.set_ylim([0,6])
ax2.set_xticks([0,25,50,75,100,125,150,175,200])#, -0.1, 0, 0.1, 0.2])
#ax2.set_yticks([0,2,4,6,8,10,12])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.tight_layout()
#plt.savefig('Std_SB.png', dpi=300)
#plt.show()
#plt.close()
############### Sim1 DSD plot ##################
f1=np.loadtxt('./Prcl/Sim1/DSD/log_DSD_r_0000001.dat')
f2=np.loadtxt('./Prcl/Sim1/DSD/log_DSD_r_0114000.dat')
f3=np.loadtxt('./Prcl/Sim1/DSD/log_DSD_r_0200000.dat')
f4=np.loadtxt('./Prcl/Sim1/DSD/log_DSD_r_0308000.dat')
f5=np.loadtxt('./Prcl/Sim1/DSD/log_DSD_r_0350000.dat')
#
f11=np.loadtxt('./Prcl/Sim2/DSD/DSD_r_0000001.dat')
f12=np.loadtxt('./Prcl/Sim2/DSD/DSD_r_0114000.dat')
f13=np.loadtxt('./Prcl/Sim2/DSD/DSD_r_0200000.dat')
f14=np.loadtxt('./Prcl/Sim2/DSD/DSD_r_0308000.dat')
f15=np.loadtxt('./Prcl/Sim2/DSD/DSD_r_0350000.dat')
#
f21=np.loadtxt('./Observation/Sim1/DSD/log_DSD_r_0000001.dat')
f22=np.loadtxt('./Observation/Sim1/DSD/log_DSD_r_0316000.dat')
f23=np.loadtxt('./Observation/Sim1/DSD/log_DSD_r_0536000.dat')
f24=np.loadtxt('./Observation/Sim1/DSD/log_DSD_r_0840000.dat')
f25=np.loadtxt('./Observation/Sim1/DSD/log_DSD_r_0936000.dat')
#
f31=np.loadtxt('./Observation/Sim2/DSD/DSD_r_0000001.dat')
f32=np.loadtxt('./Observation/Sim2/DSD/DSD_r_0316000.dat')
f33=np.loadtxt('./Observation/Sim2/DSD/DSD_r_0536000.dat')
f34=np.loadtxt('./Observation/Sim2/DSD/DSD_r_0840000.dat')
f35=np.loadtxt('./Observation/Sim2/DSD/DSD_r_0936000.dat')
#

fig, ax = plt.subplots(2, 2)#, figsize= (10,3))
#
ax[0,0].plot(f1[:,0] ,f1[:,2],color=color[2],lw=2)
ax[0,0].plot(f2[:,0] ,f2[:,2],color=color[3],lw=1)
ax[0,0].plot(f3[:,0] ,f3[:,2],color=color[8],lw=1)
ax[0,0].plot(f4[:,0] ,f4[:,2],color=color[0],lw=1)
ax[0,0].plot(f5[:,0] ,f5[:,2],color=color[1],lw=1,linestyle='dashed')
ax[0,0].set_ylabel(r"log(PDF)",fontsize=10)
#ax[0,0].set_xlabel(r"r( $\mu$m)",fontsize=12)
ax[0,0].set_title("Prcl-Simulation-1")
ax[0,0].set_xlim([0,20])
ax[0,0].set_ylim([0,15])
ax[0,0].set_xticks([0,5,10,15,20])#, -0.1, 0, 0.1, 0.2])
#ax1.set_yticks([0,2,4,6,8,10,12])
ax[0,0].xaxis.set_tick_params(labelsize=11)
ax[0,0].yaxis.set_tick_params(labelsize=11)
ax[0,0].grid()
#
ax[0,1].plot(f11[:,0] ,f11[:,2],color=color[2],lw=2)#,label='t = 0s')
ax[0,1].plot(f12[:,0] ,f12[:,2],color=color[3],lw=1)#,label='t = 2.5s')
ax[0,1].plot(f13[:,0] ,f13[:,2],color=color[8],lw=1)#,label='t = 25s')
ax[0,1].plot(f14[:,0] ,f14[:,2],color=color[0],lw=1)#,label='t = 50s')
ax[0,1].plot(f15[:,0] ,f15[:,2],color=color[1],lw=1,linestyle='dashed')#,label='t = 100s')
#ax[0,1].set_ylabel(r"log(PDF)",fontsize=10)
#ax[0,1].set_xlabel(r"r( $\mu$m)",fontsize=12)
ax[0,1].set_title("Prcl-Simulation-2")
ax[0,1].set_xlim([0,65])
ax[0,1].set_ylim([0,15])
ax[0,1].set_xticks([0,5,15,25,35,45,55,65])#, -0.1, 0, 0.1, 0.2])
#ax1.set_yticks([0,2,4,6,8,10,12])
ax[0,1].xaxis.set_tick_params(labelsize=11)
ax[0,1].yaxis.set_tick_params(labelsize=11)
ax[0,1].grid()
#
ax[1,0].plot(f21[:,0] ,f21[:,2],color=color[2],lw=2)
ax[1,0].plot(f22[:,0] ,f22[:,2],color=color[3],lw=1)
ax[1,0].plot(f23[:,0] ,f23[:,2],color=color[8],lw=1)
ax[1,0].plot(f24[:,0] ,f24[:,2],color=color[0],lw=1)
ax[1,0].plot(f25[:,0] ,f25[:,2],color=color[1],lw=1,linestyle='dashed')
ax[1,0].set_ylabel(r"log(PDF)",fontsize=10)
ax[1,0].set_xlabel(r"r( $\mu$m)",fontsize=12)
ax[1,0].set_title("Obsn-Simulation-1")
ax[1,0].set_xlim([0,25])
ax[1,0].set_ylim([0,15])
ax[1,0].set_xticks([0,5,10,15,20,25])#, -0.1, 0, 0.1, 0.2])
#ax1.set_yticks([0,2,4,6,8,10,12])
ax[1,0].xaxis.set_tick_params(labelsize=11)
ax[1,0].yaxis.set_tick_params(labelsize=11)
ax[1,0].grid()
#
ax[1,1].plot(f31[:,0] ,f31[:,2],color=color[2],lw=2,label='H= 0.1km')
ax[1,1].plot(f32[:,0] ,f32[:,2],color=color[3],lw=1,label='H = 0.3km')
ax[1,1].plot(f33[:,0] ,f33[:,2],color=color[8],lw=1,label='H = 0.5km')
ax[1,1].plot(f34[:,0] ,f34[:,2],color=color[0],lw=1,label='H = 0.9km')
ax[1,1].plot(f35[:,0] ,f35[:,2],color=color[1],lw=1,linestyle='dashed',label='H = 1.1km')
#ax[1,1].set_ylabel(r"log(PDF)",fontsize=10)
ax[1,1].set_xlabel(r"r( $\mu$m)",fontsize=12)
ax[1,1].set_title("Obsn-Simulation-2")
ax[1,1].set_xlim([0,80])
ax[1,1].set_ylim([0,15])
ax[1,1].set_xticks([0,20,40,60,80])#, -0.1, 0, 0.1, 0.2])
#ax1.set_yticks([0,2,4,6,8,10,12])
ax[1,1].xaxis.set_tick_params(labelsize=11)
ax[1,1].yaxis.set_tick_params(labelsize=11)
ax[1,1].grid()

#
plt.legend(bbox_to_anchor=(1.08,1.08), loc='upper left', borderaxespad=0.)
plt.tight_layout()
plt.savefig('DSD_SB.png', dpi=300)
plt.show()
plt.close()
###################Hgt vs Wz vs time vs Pe vs Temp##############################################
f1=np.loadtxt('./Prcl/Sim1/Time_Hgt_Wz.dat')
f2=np.loadtxt('./Observation/Sim1/Time_Hgt_Wz.dat')
f3=np.loadtxt('./Prcl/Sim1/Time_Hgt_Pe.dat')
f4=np.loadtxt('./Observation/Sim1/Time_Hgt_Pe.dat')
f5=np.loadtxt('./Prcl/Sim1/Time_Hgt_Tc.dat')
f6=np.loadtxt('./Observation/Sim1/Time_Hgt_Tc.dat')

fig, ax = plt.subplots(2, 2)#, figsize= (10,3))

ax[0,0].plot(f1[:,2]/Np1,f1[:,1]/Np1,color=color[2],lw=1, label='Prcl')
ax[0,0].plot(f2[:,2]/Np1,f2[:,1]/Np1,color=color[3],lw=1, label='Obsn')
ax[0,0].set_xlim([0,0.02])
ax[0,0].set_ylim([0.1,1.3])
ax[0,0].set_xticks([0,0.005,0.01,0.015,0.02])
ax[0,0].set_yticks([0.1,0.3,0.5,0.7,0.9,1.1,1.3])#,fontweight='bold',fontsize='10')
ax[0,0].set_xlabel(r'Wz (km/s)',fontsize=10)
ax[0,0].set_ylabel(r'H (km)',fontsize=10)
ax[0,0].legend(prop={'size':11},frameon=False)
ax[0,0].grid()
ax[0,0].xaxis.set_tick_params(labelsize=11)
ax[0,0].yaxis.set_tick_params(labelsize=11)

#ax1.legend(loc='upper right',prop={'size':7.5},frameon=False)
#
ax[0,1].plot(f1[:,0],f1[:,1]/Np1,color=color[2],lw=1, label='Prcl')
ax[0,1].plot(f2[:,0],f2[:,1]/Np1,color=color[3],lw=1, label='Obsn')
ax[0,1].set_xlim([0,500])
ax[0,1].set_ylim([0.1,1.3])
ax[0,1].set_xticks([0,100,200,300,400,500])
ax[0,1].set_yticks([0.1,0.3,0.5,0.7,0.9,1.1,1.3])#,fontweight='bold',fontsize='10')
#ax[0,1].yticks((342,343,344),fontweight='bold',fontsize='10')
#ax[0,1].xticks((340),fontweight='bold',fontsize='10')
ax[0,1].set_xlabel(r't (s)',fontsize=10)
ax[0,1].set_ylabel(r'H (km)',fontsize=10)
ax[0,1].legend(prop={'size':11},frameon=False)
ax[0,1].grid()
ax[0,1].xaxis.set_tick_params(labelsize=11)
ax[0,1].yaxis.set_tick_params(labelsize=11)

#
ax[1,0].plot(f3[:,2]/1000 ,f3[:,1]/Np1,color=color[2],lw=1,label='Prcl')
ax[1,0].plot(f4[:,2]/1000 ,f4[:,1]/Np1,color=color[3],lw=1,label='Obsn')
ax[1,0].set_xlim([660,760])
ax[1,0].set_ylim([0.1,1.3])
ax[1,0].set_xticks([660,680,700,720,740,760])
ax[1,0].set_yticks([0.1,0.3,0.5,0.7,0.9,1.1,1.3])#,fontweight='bold',fontsize='10')
#plt.yticks((2,4,6,8,10),fontweight='bold',fontsize='10')
ax[1,0].set_xlabel(r'Pe (hPa)',fontsize=10)
ax[1,0].set_ylabel(r'H (km)',fontsize=10)
ax[1,0].legend(loc='upper right',prop={'size':9},frameon=False)
ax[1,0].grid()
ax[1,0].xaxis.set_tick_params(labelsize=11)
ax[1,0].yaxis.set_tick_params(labelsize=11)
#
ax[1,1].plot(f5[:,2],f5[:,1]/Np1,color=color[2],lw=1, label='Prcl')
ax[1,1].plot(f6[:,2],f6[:,1]/Np1,color=color[3],lw=1, label='Obsn')
ax[1,1].set_xlim([280,288])
ax[1,1].set_ylim([0.1,1.3])
ax[1,1].set_xticks([280,282,284,286,288])
ax[1,1].set_yticks([0.1,0.3,0.5,0.7,0.9,1.1,1.3])#,fontweight='bold',fontsize='10')
#plt.xticks((340),fontweight='bold',fontsize='10')
ax[1,1].set_xlabel(r'T(K)',fontsize=10)
ax[1,1].set_ylabel(r'Hgt (km)',fontsize=10)
ax[1,1].legend(prop={'size':11},frameon=False)
ax[1,1].grid()
ax[1,1].xaxis.set_tick_params(labelsize=11)
ax[1,1].yaxis.set_tick_params(labelsize=11)

#
#plt.grid()
#plt.gca().add_artist(legend1)
plt.tight_layout()
plt.savefig('Dynamic_SB.png', dpi=300)
plt.show()
plt.close()

