#=====================================================================
import numpy as np
import math
import matplotlib.pyplot as plt
#import matplotlib as plt
from matplotlib import rc
#import csv
#====================Plotting ==========================================
import matplotlib.pyplot as plt

from matplotlib import rc

rc('text',usetex=True)
font = {'size'   : 15}
rc('font', **font)
#
color=['b','r','k','g','orange','c','b','#f781bf']
################################################################
#============================================================
data_1 = np.loadtxt("./rd1_1st_cld/r_mean.dat")
data_2 = np.loadtxt("./rd1_1st_cld/r_Num_Con.dat")
data_3 = np.loadtxt("./rd1_1st_cld/Ml_Vol.dat")
data_4 = np.loadtxt('./rd1_1st_cld/r_stand_div.dat')
f1 = open("./rd1_1st_cld/LD_auto_conversion.dat","w")
f2 = open("./rd1_1st_cld/Sun_auto_conversion.dat","w")
N2 = 8001
rho_w = 1
Np1 = 25.6**3
k = 1.1*(10**3)             #*(10**10)
c_s = 0.0001*10**(-6)
L_c = 0.5*(100**(-3))
for i in range(0,N2):
	Np = data_2[i][2]/Np1
	data_3[i][1] = (data_3[i][1])*(100**(-3))
	eps = (data_4[i][2])/(data_1[i][2])
	eps_sqr = eps**2
	beta_6 = (((1+3*eps_sqr)*(1+4*eps_sqr)*(1+5*eps_sqr))/((1+eps_sqr)*(1+2*eps_sqr)))**(1/6)
	x_s = (data_1[i][2] / 10)**3 
	P_LD1 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**2))
	P_LD2 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**4))
	T_s = 1 - math.exp(-(data_3[i][1]/L_c)**2)
	P_s = c_s*(data_3[i][1])*T_s
	f1.write("%s\t\t\t%s\t\t\t%s\n" % (eps,P_LD1,P_LD2))
	f2.write("%s\t\t\t%s\n" % (eps,P_s))
f1.close()
f2.close()
#============================================================
data_1 = np.loadtxt("./rd2_1st_cld/r_mean.dat")
data_2 = np.loadtxt("./rd2_1st_cld/r_Num_Con.dat")
data_3 = np.loadtxt("./rd2_1st_cld/Ml_Vol.dat")
data_4 = np.loadtxt('./rd2_1st_cld/r_stand_div.dat')
f1 = open("./rd2_1st_cld/LD_auto_conversion.dat","w")
f2 = open("./rd2_1st_cld/Sun_auto_conversion.dat","w")
N2 = 8001
rho_w = 1
Np1 = 25.6**3
k = 1.1*(10**3)             #*(10**10)
c_s = 0.0001*10**(-6)
L_c = 0.5*(100**(-3))
for i in range(0,N2):
	Np = data_2[i][2]/Np1
	data_3[i][1] = (data_3[i][1])*(100**(-3))
	eps = data_4[i][2]/data_1[i][2]
	eps_sqr = eps**2
	beta_6 = (((1+3*eps_sqr)*(1+4*eps_sqr)*(1+5*eps_sqr))/((1+eps_sqr)*(1+2*eps_sqr)))**(1/6)
	x_s = (data_1[i][2] / 10)**3
	P_LD1 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**2))
	P_LD2 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**4))
	T_s = 1 - math.exp(-(data_3[i][1]/L_c)**2)
	P_s = c_s*(data_3[i][1])*T_s
	f1.write("%s\t\t\t%s\t\t\t%s\n" % (eps,P_LD1,P_LD2))
	f2.write("%s\t\t\t%s\n" % (eps,P_s))
f1.close()
f2.close()
#============================================================
data_1 = np.loadtxt("./rd3_1st_cld/r_mean.dat")
data_2 = np.loadtxt("./rd3_1st_cld/r_Num_Con.dat")
data_3 = np.loadtxt("./rd3_1st_cld/Ml_Vol.dat")
data_4 = np.loadtxt('./rd3_1st_cld/r_stand_div.dat')
f1 = open("./rd3_1st_cld/LD_auto_conversion.dat","w")
f2 = open("./rd3_1st_cld/Sun_auto_conversion.dat","w")
N2 = 8001
rho_w = 1
Np1 = 25.6**3
k = 1.1*(10**3)           #*(10**10)
c_s = 0.0001*10**(-6)
L_c = 0.5*(100**(-3))
for i in range(0,N2):
	Np = data_2[i][2]/Np1
	data_3[i][1] = (data_3[i][1])*(100**(-3))
	eps = data_4[i][2]/data_1[i][2]
	eps_sqr = eps**2
	beta_6 = (((1+3*eps_sqr)*(1+4*eps_sqr)*(1+5*eps_sqr))/((1+eps_sqr)*(1+2*eps_sqr)))**(1/6)
	x_s = (data_1[i][2] / 10)**3
	P_LD1 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**2))
	P_LD2 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**4))
	T_s = 1 - math.exp(-(data_3[i][1]/L_c)**2)
	P_s = c_s*(data_3[i][1])*T_s
	f1.write("%s\t\t\t%s\t\t\t%s\n" % (eps,P_LD1,P_LD2))
	f2.write("%s\t\t\t%s\n" % (eps,P_s))
f1.close()
f2.close()
#============================================================
data_1 = np.loadtxt("./rd4_1st_cld/r_mean.dat")
data_2 = np.loadtxt("./rd4_1st_cld/r_Num_Con.dat")
data_3 = np.loadtxt("./rd4_1st_cld/Ml_Vol.dat")
data_4 = np.loadtxt('./rd4_1st_cld/r_stand_div.dat')
f1 = open("./rd4_1st_cld/LD_auto_conversion.dat","w")
f2 = open("./rd4_1st_cld/Sun_auto_conversion.dat","w")
f3 = open("./rd4_1st_cld/mu4_LD_auto_conversion.dat","w")
N2 = 8001
rho_w = 1
Np1 = 25.6**3
k = 1.1*(10**3)                   #*(10**10)
c_s = 0.0001*10**(-6)
L_c = 0.5*(100**(-3))
for i in range(0,N2):
	Np = data_2[i][2]/Np1
	data_3[i][1] = (data_3[i][1])*(100**(-3))
	eps = data_4[i][2]/data_1[i][2]
	eps_sqr = eps**2
	beta_6 = (((1+3*eps_sqr)*(1+4*eps_sqr)*(1+5*eps_sqr))/((1+eps_sqr)*(1+2*eps_sqr)))**(1/6)
	x_s = (data_1[i][2] / 10)**3
	p2 = (1-math.exp((-1)*(x_s**2)))
	p4 = (1-math.exp((-1)*(x_s**4)))
	P_LD = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*p2
	mu4P_LD = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*p4
	T_s = 1 - math.exp(-(data_3[i][1]/L_c)**2)
	P_s = c_s*(data_3[i][1])*T_s
	f1.write("%s\t\t\t%s\t\t%s\n" % (eps,P_LD,p2))
	f2.write("%s\t\t\t%s\n" % (eps,P_s))
	f3.write("%s\t\t\t%s\t\t%s\n" % (eps,mu4P_LD,p4))
f1.close()
f2.close()
f3.close()
#============================================================
data_1 = np.loadtxt("./rd5_1st_cld/r_mean.dat")
data_2 = np.loadtxt("./rd5_1st_cld/r_Num_Con.dat")
data_3 = np.loadtxt("./rd5_1st_cld/Ml_Vol.dat")
data_4 = np.loadtxt('./rd5_1st_cld/r_stand_div.dat')
f1 = open("./rd5_1st_cld/LD_auto_conversion.dat","w")
f2 = open("./rd5_1st_cld/Sun_auto_conversion.dat","w")
N2 = 8001
rho_w = 1
Np1 = 25.6**3
k = 1.1*(10**3)       #*(10**10)
c_s = 0.0001*10**(-6)
L_c = 0.5*(100**(-3))
for i in range(0,N2):
	Np = data_2[i][2]/Np1
	data_3[i][1] = (data_3[i][1])*(100**(-3))
	eps = data_4[i][2]/data_1[i][2]
	eps_sqr = eps**2
	beta_6 = (((1+3*eps_sqr)*(1+4*eps_sqr)*(1+5*eps_sqr))/((1+eps_sqr)*(1+2*eps_sqr)))**(1/6)
	x_s = (data_1[i][2] / 10)**3
	P_LD1 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**2))
	P_LD2 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**4))
	T_s = 1 - math.exp(-(data_3[i][1]/L_c)**2)
	P_s = c_s*(data_3[i][1])*T_s
	f1.write("%s\t\t\t%s\t\t\t%s\n" % (eps,P_LD1,P_LD2))
	f2.write("%s\t\t\t%s\n" % (eps,P_s))
f1.close()
f2.close()
#============================================================
data_1 = np.loadtxt("./rd6_1st_cld/r_mean.dat")
data_2 = np.loadtxt("./rd6_1st_cld/r_Num_Con.dat")
data_3 = np.loadtxt("./rd6_1st_cld/Ml_Vol.dat")
data_4 = np.loadtxt('./rd6_1st_cld/r_stand_div.dat')
f1 = open("./rd6_1st_cld/LD_auto_conversion.dat","w")
f2 = open("./rd6_1st_cld/Sun_auto_conversion.dat","w")
N2 = 8001
rho_w = 1
Np1 = 25.6**3
k = 1.1 *(10**3)               #*(10**10)
c_s = 0.0001*10**(-6)
L_c = 0.5*(100**(-3))
for i in range(0,N2):
	Np = data_2[i][2]/Np1
	data_3[i][1] = (data_3[i][1])*(100**(-3))
	eps = data_4[i][2]/data_1[i][2]
	eps_sqr = eps**2
	beta_6 = (((1+3*eps_sqr)*(1+4*eps_sqr)*(1+5*eps_sqr))/((1+eps_sqr)*(1+2*eps_sqr)))**(1/6)
	x_s = (data_1[i][2] / 10)**3
	P_LD1 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**2))
	P_LD2 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**4))
	T_s = 1 - math.exp(-(data_3[i][1]/L_c)**2)
	P_s = c_s*(data_3[i][1])*T_s
	f1.write("%s\t\t\t%s\t\t\t%s\n" % (eps,P_LD1,P_LD2))
	f2.write("%s\t\t\t%s\n" % (eps,P_s))
f1.close()
f2.close()
#============================================================
data_1 = np.loadtxt("./rd7_1st_cld/r_mean.dat")
data_2 = np.loadtxt("./rd7_1st_cld/r_Num_Con.dat")
data_3 = np.loadtxt("./rd7_1st_cld/Ml_Vol.dat")
data_4 = np.loadtxt('./rd7_1st_cld/r_stand_div.dat')
f1 = open("./rd7_1st_cld/LD_auto_conversion.dat","w")
f2 = open("./rd7_1st_cld/Sun_auto_conversion.dat","w")
N2 = 8001
rho_w = 1
Np1 = 25.6**3
k = 1.1*(10**3)                  #*(10**10)
c_s = 0.0001*10**(-6)
L_c = 0.5*(100**(-3))
for i in range(0,N2):
	Np = data_2[i][2]/Np1
	data_3[i][1] = (data_3[i][1])*(100**(-3))
	eps = data_4[i][2]/data_1[i][2]
	eps_sqr = eps**2
	beta_6 = (((1+3*eps_sqr)*(1+4*eps_sqr)*(1+5*eps_sqr))/((1+eps_sqr)*(1+2*eps_sqr)))**(1/6)
	x_s = (data_1[i][2] / 10)**3
	P_LD1 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**2))
	P_LD2 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**4))
	T_s = 1 - math.exp(-(data_3[i][1]/L_c)**2)
	P_s = c_s*(data_3[i][1])*T_s
	f1.write("%s\t\t\t%s\t\t\t%s\n" % (eps,P_LD1,P_LD2))
	f2.write("%s\t\t\t%s\n" % (eps,P_s))
f1.close()
f2.close()
#============================================================
data_1 = np.loadtxt("./rd1_2nd_cld/r_mean.dat")
data_2 = np.loadtxt("./rd1_2nd_cld/r_Num_Con.dat")
data_3 = np.loadtxt("./rd1_2nd_cld/Ml_Vol.dat")
data_4 = np.loadtxt('./rd1_2nd_cld/r_stand_div.dat')
f1 = open("./rd1_2nd_cld/LD_auto_conversion.dat","w")
f2 = open("./rd1_2nd_cld/Sun_auto_conversion.dat","w")
N2 = 8001
rho_w = 1
Np1 = 25.6**3
k = 1.1*(10**3)                    #*(10**10)
c_s = 0.0001*10**(-6)
L_c = 0.5*(100**(-3))
for i in range(0,N2):
	Np = data_2[i][2]/Np1
	data_3[i][1] = (data_3[i][1])*(100**(-3))
	eps = data_4[i][2]/data_1[i][2]
	eps_sqr = eps**2
	beta_6 = (((1+3*eps_sqr)*(1+4*eps_sqr)*(1+5*eps_sqr))/((1+eps_sqr)*(1+2*eps_sqr)))**(1/6)
	x_s = (data_1[i][2] / 10)**3
	P_LD1 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**2))
	P_LD2 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**4))
	T_s = 1 - math.exp(-(data_3[i][1]/L_c)**2)
	P_s = c_s*(data_3[i][1])*T_s
	f1.write("%s\t\t\t%s\t\t\t%s\n" % (eps,P_LD1,P_LD2))
	f2.write("%s\t\t\t%s\n" % (eps,P_s))
f1.close()
f2.close()
#============================================================
data_1 = np.loadtxt("./rd2_2nd_cld/r_mean.dat")
data_2 = np.loadtxt("./rd2_2nd_cld/r_Num_Con.dat")
data_3 = np.loadtxt("./rd2_2nd_cld/Ml_Vol.dat")
data_4 = np.loadtxt('./rd2_2nd_cld/r_stand_div.dat')
f1 = open("./rd2_2nd_cld/LD_auto_conversion.dat","w")
f2 = open("./rd2_2nd_cld/Sun_auto_conversion.dat","w")
N2 = 8001
rho_w = 1
Np1 = 25.6**3
k = 1.1*(10**3)               #*(10**10)
c_s = 0.0001*10**(-6)
L_c = 0.5*(100**(-3))
for i in range(0,N2):
	Np = data_2[i][2]/Np1
	data_3[i][1] = (data_3[i][1])*(100**(-3))
	eps = data_4[i][2]/data_1[i][2]
	eps_sqr = eps**2
	beta_6 = (((1+3*eps_sqr)*(1+4*eps_sqr)*(1+5*eps_sqr))/((1+eps_sqr)*(1+2*eps_sqr)))**(1/6)
	x_s = (data_1[i][2] / 10)**3
	P_LD1 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**2))
	P_LD2 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**4))
	T_s = 1 - math.exp(-(data_3[i][1]/L_c)**2)
	P_s = c_s*(data_3[i][1])*T_s
	f1.write("%s\t\t\t%s\t\t\t%s\n" % (eps,P_LD1,P_LD2))
	f2.write("%s\t\t\t%s\n" % (eps,P_s))
f1.close()
f2.close()
#============================================================
data_1 = np.loadtxt("./rd3_2nd_cld/r_mean.dat")
data_2 = np.loadtxt("./rd3_2nd_cld/r_Num_Con.dat")
data_3 = np.loadtxt("./rd3_2nd_cld/Ml_Vol.dat")
data_4 = np.loadtxt('./rd3_2nd_cld/r_stand_div.dat')
f1 = open("./rd3_2nd_cld/LD_auto_conversion.dat","w")
f2 = open("./rd3_2nd_cld/Sun_auto_conversion.dat","w")
N2 = 8001
rho_w = 1
Np1 = 25.6**3
k = 1.1*(10**3)               #*(10**10)
c_s = 0.0001*10**(-6)
L_c = 0.5*(100**(-3))
for i in range(0,N2):
	Np = data_2[i][2]/Np1
	data_3[i][1] = (data_3[i][1])*(100**(-3))
	eps = data_4[i][2]/data_1[i][2]
	eps_sqr = eps**2
	beta_6 = (((1+3*eps_sqr)*(1+4*eps_sqr)*(1+5*eps_sqr))/((1+eps_sqr)*(1+2*eps_sqr)))**(1/6)
	x_s = (data_1[i][2] / 10)**3
	P_LD1 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**2))
	P_LD2 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**4))
	T_s = 1 - math.exp(-(data_3[i][1]/L_c)**2)
	P_s = c_s*(data_3[i][1])*T_s
	f1.write("%s\t\t\t%s\t\t\t%s\n" % (eps,P_LD1,P_LD2))
	f2.write("%s\t\t\t%s\n" % (eps,P_s))
f1.close()
f2.close()
#============================================================
data_1 = np.loadtxt("./rd4_2nd_cld/r_mean.dat")
data_2 = np.loadtxt("./rd4_2nd_cld/r_Num_Con.dat")
data_3 = np.loadtxt("./rd4_2nd_cld/Ml_Vol.dat")
data_4 = np.loadtxt('./rd4_2nd_cld/r_stand_div.dat')
f1 = open("./rd4_2nd_cld/LD_auto_conversion.dat","w")
f2 = open("./rd4_2nd_cld/Sun_auto_conversion.dat","w")
N2 = 8001
rho_w = 1
Np1 = 25.6**3
k = 1.1*(10**3)          #*(10**10)
c_s = 0.0001*10**(-6)
L_c = 0.5*(100**(-3))
for i in range(0,N2):
	Np = data_2[i][2]/Np1
	data_3[i][1] = (data_3[i][1])*(100**(-3))
	eps = data_4[i][2]/data_1[i][2]
	eps_sqr = eps**2
	beta_6 = (((1+3*eps_sqr)*(1+4*eps_sqr)*(1+5*eps_sqr))/((1+eps_sqr)*(1+2*eps_sqr)))**(1/6)
	x_s = (data_1[i][2] / 10)**3
	P_LD1 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**2))
	P_LD2 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**4))
	T_s = 1 - math.exp(-(data_3[i][1]/L_c)**2)
	P_s = c_s*(data_3[i][1])*T_s
	f1.write("%s\t\t\t%s\t\t\t%s\n" % (eps,P_LD1,P_LD2))
	f2.write("%s\t\t\t%s\n" % (eps,P_s))
f1.close()
f2.close()
#============================================================
data_1 = np.loadtxt("./rd5_2nd_cld/r_mean.dat")
data_2 = np.loadtxt("./rd5_2nd_cld/r_Num_Con.dat")
data_3 = np.loadtxt("./rd5_2nd_cld/Ml_Vol.dat")
data_4 = np.loadtxt('./rd5_2nd_cld/r_stand_div.dat')
f1 = open("./rd5_2nd_cld/LD_auto_conversion.dat","w")
f2 = open("./rd5_2nd_cld/Sun_auto_conversion.dat","w")
N2 = 8001
rho_w = 1
Np1 = 25.6**3
k = 1.1*(10**3)                 #*(10**10)
c_s = 0.0001*10**(-6)
L_c = 0.5*(100**(-3))
for i in range(0,N2):
	Np = data_2[i][2]/Np1
	data_3[i][1] = (data_3[i][1])*(100**(-3))
	eps = data_4[i][2]/data_1[i][2]
	eps_sqr = eps**2
	beta_6 = (((1+3*eps_sqr)*(1+4*eps_sqr)*(1+5*eps_sqr))/((1+eps_sqr)*(1+2*eps_sqr)))**(1/6)
	x_s = (data_1[i][2] / 10)**3
	P_LD1 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**2))
	P_LD2 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**4))
	T_s = 1 - math.exp(-(data_3[i][1]/L_c)**2)
	P_s = c_s*(data_3[i][1])*T_s
	f1.write("%s\t\t\t%s\t\t\t%s\n" % (eps,P_LD1,P_LD2))
	f2.write("%s\t\t\t%s\n" % (eps,P_s))
f1.close()
f2.close()
#============================================================
data_1 = np.loadtxt("./rd6_2nd_cld/r_mean.dat")
data_2 = np.loadtxt("./rd6_2nd_cld/r_Num_Con.dat")
data_3 = np.loadtxt("./rd6_2nd_cld/Ml_Vol.dat")
data_4 = np.loadtxt('./rd6_2nd_cld/r_stand_div.dat')
f1 = open("./rd6_2nd_cld/LD_auto_conversion.dat","w")
f2 = open("./rd6_2nd_cld/Sun_auto_conversion.dat","w")
N2 = 8001
rho_w = 1
Np1 = 25.6**3
k = 1.1*(10**3)                   #*(10**10)
c_s = 0.0001*10**(-6)
L_c = 0.5*(100**(-3))
for i in range(0,N2):
	Np = data_2[i][2]/Np1
	data_3[i][1] = (data_3[i][1])*(100**(-3))
	eps = data_4[i][2]/data_1[i][2]
	eps_sqr = eps**2
	beta_6 = (((1+3*eps_sqr)*(1+4*eps_sqr)*(1+5*eps_sqr))/((1+eps_sqr)*(1+2*eps_sqr)))**(1/6)
	x_s = (data_1[i][2] / 10)**3
	P_LD1 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**2))
	P_LD2 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**4))
	T_s = 1 - math.exp(-(data_3[i][1]/L_c)**2)
	P_s = c_s*(data_3[i][1])*T_s
	f1.write("%s\t\t\t%s\t\t\t%s\n" % (eps,P_LD1,P_LD2))
	f2.write("%s\t\t\t%s\n" % (eps,P_s))
f1.close()
f2.close()
#============================================================
data_1 = np.loadtxt("./rd7_2nd_cld/r_mean.dat")
data_2 = np.loadtxt("./rd7_2nd_cld/r_Num_Con.dat")
data_3 = np.loadtxt("./rd7_2nd_cld/Ml_Vol.dat")
data_4 = np.loadtxt('./rd7_2nd_cld/r_stand_div.dat')
f1 = open("./rd7_2nd_cld/LD_auto_conversion.dat","w")
f2 = open("./rd7_2nd_cld/Sun_auto_conversion.dat","w")
N2 = 8001
rho_w = 1
Np1 = 25.6**3
k = 1.1*(10**3)          #*(10**10)
c_s = 0.0001*10**(-6)
L_c = 0.5*(100**(-3))
for i in range(0,N2):
	Np = data_2[i][2]/Np1
	data_3[i][1] = (data_3[i][1])*(100**(-3))
	eps = data_4[i][2]/data_1[i][2]
	eps_sqr = eps**2
	beta_6 = (((1+3*eps_sqr)*(1+4*eps_sqr)*(1+5*eps_sqr))/((1+eps_sqr)*(1+2*eps_sqr)))**(1/6)
	x_s = (data_1[i][2] / 10)**3
	P_LD1 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**2))
	P_LD2 = k*(beta_6**6)*(Np**(-1))*(data_3[i][1]**3)*(1-math.exp(-x_s**4))
	T_s = 1 - math.exp(-(data_3[i][1]/L_c)**2)
	P_s = c_s*(data_3[i][1])*T_s
	f1.write("%s\t\t\t%s\t\t\t%s\n" % (eps,P_LD1,P_LD2))
	f2.write("%s\t\t\t%s\n" % (eps,P_s))
f1.close()
f2.close()
###############################################################
#-----------------1st cloud--------------------------------
f11=np.loadtxt('./rd1_1st_cld/Ml_Vol.dat')
f12=np.loadtxt('./rd2_1st_cld/Ml_Vol.dat')
f13=np.loadtxt('./rd3_1st_cld/Ml_Vol.dat')
f14=np.loadtxt('./rd4_1st_cld/Ml_Vol.dat')
f15=np.loadtxt('./rd5_1st_cld/Ml_Vol.dat')
f16=np.loadtxt('./rd6_1st_cld/Ml_Vol.dat')
f17=np.loadtxt('./rd7_1st_cld/Ml_Vol.dat')
#-----------------2nd cloud--------------------------------
f21=np.loadtxt('./rd1_2nd_cld/Ml_Vol.dat')
f22=np.loadtxt('./rd2_2nd_cld/Ml_Vol.dat')
f23=np.loadtxt('./rd3_2nd_cld/Ml_Vol.dat')
f24=np.loadtxt('./rd4_2nd_cld/Ml_Vol.dat')
f25=np.loadtxt('./rd5_2nd_cld/Ml_Vol.dat')
f26=np.loadtxt('./rd6_2nd_cld/Ml_Vol.dat')
f27=np.loadtxt('./rd7_2nd_cld/Ml_Vol.dat')
#-----------------1st cloud--------------------------------
f111=np.loadtxt('./rd1_1st_cld/LD_auto_conversion.dat')
f112=np.loadtxt('./rd2_1st_cld/LD_auto_conversion.dat')
f113=np.loadtxt('./rd3_1st_cld/LD_auto_conversion.dat')
f114=np.loadtxt('./rd4_1st_cld/LD_auto_conversion.dat')
f115=np.loadtxt('./rd5_1st_cld/LD_auto_conversion.dat')
f116=np.loadtxt('./rd6_1st_cld/LD_auto_conversion.dat')
f117=np.loadtxt('./rd7_1st_cld/LD_auto_conversion.dat')
#-----------------2nd cloud--------------------------------
f121=np.loadtxt('./rd1_2nd_cld/LD_auto_conversion.dat')
f122=np.loadtxt('./rd2_2nd_cld/LD_auto_conversion.dat')
f123=np.loadtxt('./rd3_2nd_cld/LD_auto_conversion.dat')
f124=np.loadtxt('./rd4_2nd_cld/LD_auto_conversion.dat')
f125=np.loadtxt('./rd5_2nd_cld/LD_auto_conversion.dat')
f126=np.loadtxt('./rd6_2nd_cld/LD_auto_conversion.dat')
f127=np.loadtxt('./rd7_2nd_cld/LD_auto_conversion.dat')
#
########## Hgt vs Number concentration##################################
#-----------------1st cloud--------------------------------
f211=np.loadtxt('./rd1_1st_cld/Sun_auto_conversion.dat')
f212=np.loadtxt('./rd2_1st_cld/Sun_auto_conversion.dat')
f213=np.loadtxt('./rd3_1st_cld/Sun_auto_conversion.dat')
f214=np.loadtxt('./rd4_1st_cld/Sun_auto_conversion.dat')
f215=np.loadtxt('./rd5_1st_cld/Sun_auto_conversion.dat')
f216=np.loadtxt('./rd6_1st_cld/Sun_auto_conversion.dat')
f217=np.loadtxt('./rd7_1st_cld/Sun_auto_conversion.dat')
#-----------------2nd cloud--------------------------------
f221=np.loadtxt('./rd1_2nd_cld/Sun_auto_conversion.dat')
f222=np.loadtxt('./rd2_2nd_cld/Sun_auto_conversion.dat')
f223=np.loadtxt('./rd3_2nd_cld/Sun_auto_conversion.dat')
f224=np.loadtxt('./rd4_2nd_cld/Sun_auto_conversion.dat')
f225=np.loadtxt('./rd5_2nd_cld/Sun_auto_conversion.dat')
f226=np.loadtxt('./rd6_2nd_cld/Sun_auto_conversion.dat')
f227=np.loadtxt('./rd7_2nd_cld/Sun_auto_conversion.dat')
#
Np = 25.6**3
################# k vs dispersion#######################################
fig,(ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f14[:,1],f114[:,1],color=color[1],lw=2,label='Liu-Daum,Shallow cloud')
ax1.plot(f24[:,1],f124[:,1],color=color[6],lw=2,label='Liu-Daum,Convective Cloud')
#ax1.plot(f14[:,1],f114[:,2],color=color[6],lw=2,linestyle='dotted',label='Liu-Daum,$\mu$ = 4')
ax1.plot(f14[:,1],f214[:,1],color=color[7],lw=2,linestyle='dotted',label='Sundquist,Shallow cloud')
#ax1.plot(f24[:,1],f124[:,1],color=color[6],lw=2,linestyle='dotted',label='Liu-Daum,Convective Cloud')
ax1.plot(f24[:,1],f224[:,1],color=color[5],lw=2,linestyle='dashed',label='Sundquist, Convective Cloud')
#ax1.set_xlabel(r'LWC (g/cc)',fontsize=10)
#ax1.set_ylabel(r'Autoconversion Rate (g $cm^(-3) s^(-1)$)',fontsize=10)
#ax1.set_title("1st cloud,$r_d$ = 0.1$\mu$m")
ax1.set_xlim([0,4])
ax1.set_ylim([0,1.2e-15])
ax1.set_yticks([0,2e-16,4e-16,6e-16,8e-16,1e-15,1.2e-15])#, -0.1, 0, 0.1, 0.2])
#ax1.set_xticks([0.1,0.2,0.3,0.4])
#ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
#ax1.ticklabel_format(style='sci',scilimits=(-16,4),axis='y')
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f13[:,1],f113[:,1],color=color[1],lw=2,label='Liu-Daum,$1^{st}$ cloud')
ax2.plot(f23[:,1],f123[:,1],color=color[6],lw=2,label='Liu-Daum,$2^{nd}$ Cloud')
#ax2.plot(f14[:,1],f114[:,2],color=color[6],lw=2,linestyle='dotted',label='Liu-Daum,$\mu$ = 4')
ax2.plot(f13[:,1],f213[:,1],color=color[7],lw=2,linestyle='dotted',label='Sundquist,$1^{st}$ cloud')
#ax2.plot(f23[:,1],f123[:,1],color=color[6],lw=2,linestyle='dotted',label='Liu-Daum,$2^{nd}$ Cloud')
ax2.plot(f23[:,1],f223[:,1],color=color[5],lw=2,linestyle='dashed',label='Sundquist, $2^{nd}$ Cloud')
#ax1.set_xlabel(r'LWC (g/cc)',fontsize=10)
#ax1.set_ylabel(r'Autoconversion Rate (g $cm^(-3) s^(-1)$)',fontsize=10)
#ax1.set_title("1st cloud,$r_d$ = 0.1$\mu$m")
ax2.set_xlim([0,4])
ax2.set_ylim([0,1.2e-15])
ax2.set_yticks([0,2e-16,4e-16,6e-16,8e-16,1e-15,1.2e-15])#, -0.1, 0, 0.1, 0.2])
#ax2.set_xticks([0.1,0.2,0.3,0.4])
#ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
#ax2.ticklabel_format(style='sci',scilimits=(-16,4),axis='y')
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
plt.legend(bbox_to_anchor=(1.08,1.08), loc='upper left', borderaxespad=0.)
plt.tight_layout()
plt.savefig('1_rd3_rd4_autocon_LWC.png', dpi=300)
plt.show()
plt.close()

#
ax2.plot(f24[:,1],f124[:,1],color=color[1],lw=2,label='Liu-Daum,$\mu$ = 2')
ax2.plot(f24[:,1],f124[:,2],color=color[6],lw=2,linestyle='dotted',label='Liu-Daum,$\mu$ = 4')
ax2.plot(f24[:,1],f224[:,1],color=color[7],lw=2,linestyle='dashed',label='Sundquist')
#ax2.set_xlabel(r"LWC (g/cc)",fontsize=10)
#ax2.set_ylabel(r'Autoconversion Rate (g $cm^(-3) s^(-1)$)',fontsize=10)
#ax2.set_title("2nd Cloud,$r_d$ = 0.1$\mu$m")
ax2.set_xlim([0,4])
ax2.set_ylim([0,1.2e-15])
ax2.set_yticks([0,2e-16,4e-16,6e-16,8e-16,1e-15,1.2e-15])#, -0.1, 0, 0.1, 0.2])
#ax2.set_xticks([0.1,0.2,0.3,0.4])
#ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
#ax2.ticklabel_format(style='sci',scilimits=(-16,4),axis='y')
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend1)
#plt.legend(bbox_to_anchor=(1.08,1.08), loc='upper left', borderaxespad=0.)
plt.tight_layout()
plt.savefig('autocon_LWC_rd4.png', dpi=300)
plt.show()
plt.close()
##################################################################
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,2],f411[:,1],color=color[1],lw=2,label='$r_d1$')
ax1.plot(f12[:,2],f412[:,1],color=color[2],lw=1,label='$r_d2$')
ax1.plot(f13[:,2],f413[:,1],color=color[3],lw=1,label='$r_d3$')
ax1.plot(f14[:,2],f414[:,1],color=color[4],lw=1,label='$r_d4$')
ax1.plot(f15[:,2],f415[:,1],color=color[5],lw=1,label='$r_d5$')
ax1.plot(f16[:,2],f416[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d6$')
ax1.plot(f17[:,2],f417[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d7$')
ax1.set_xlabel(r'$D_m$($\mu$m)',fontsize=14)
ax1.set_ylabel(r'k',fontsize=14)
#ax1.set_title("1st cloud")
ax1.set_xlim([14,20])
ax1.set_ylim([0.6,1])
ax1.set_yticks([0.6,0.65,0.7,0.75,0.8,0.85,0.9,0.95,1])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([14,16,18,20])
#ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f21[:,2],f421[:,1],color=color[1],lw=2,label='$r_d$$_1$ = 0.05$\mu$m')
ax2.plot(f22[:,2],f422[:,1],color=color[2],lw=1,label='$r_d$$_2$ = 0.07$\mu$m')
ax2.plot(f23[:,2],f423[:,1],color=color[3],lw=1,label='$r_d$$_3$ = 0.09$\mu$m')
ax2.plot(f24[:,2],f424[:,1],color=color[4],lw=1,label='$r_d$$_4$ = 0.1$\mu$m')
ax2.plot(f25[:,2],f425[:,1],color=color[5],lw=1,label='$r_d$$_5$ = 0.5$\mu$m')
ax2.plot(f26[:,2],f426[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d$$_6$ = 0.7$\mu$m')
ax2.plot(f27[:,2],f427[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d$$_7$ = 0.9$\mu$m')
ax2.set_xlabel(r"$D_m$($\mu$m)",fontsize=14)
ax2.set_ylabel(r'k',fontsize=14)
#ax2.set_title("2nd Cloud")
ax2.set_xlim([14,20])
ax2.set_ylim([0.6,1])
ax2.set_yticks([0.6,0.65,0.7,0.75,0.8,0.85,0.9,0.95,1])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([14,16,18,20])
#ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend1)
#plt.legend(bbox_to_anchor=(1.08,1.08), loc='upper left', borderaxespad=0.)
plt.tight_layout()
plt.savefig('autocon_LWC.png', dpi=300)
plt.show()
plt.close()
########################################################################
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f211[:,2]/Np,f111[:,2]/f11[:,2],color=color[1],lw=2,label='$r_d1$')
ax1.plot(f212[:,2]/Np,f112[:,2]/f12[:,2],color=color[2],lw=1,label='$r_d2$')
ax1.plot(f213[:,2]/Np,f113[:,2]/f13[:,2],color=color[3],lw=1,label='$r_d3$')
ax1.plot(f214[:,2]/Np,f114[:,2]/f14[:,2],color=color[4],lw=1,label='$r_d4$')
ax1.plot(f215[:,2]/Np,f115[:,2]/f15[:,2],color=color[5],lw=1,label='$r_d5$')
ax1.plot(f216[:,2]/Np,f116[:,2]/f16[:,2],color=color[6],lw=1,linestyle='dotted',label='$r_d6$')
ax1.plot(f217[:,2]/Np,f117[:,2]/f17[:,2],color=color[7],lw=1,linestyle='dashed',label='$r_d7$')
ax1.set_ylabel(r'$\epsilon$',fontsize=14)
ax1.set_xlabel(r'NC(/cc)',fontsize=14)
#ax1.set_title("1st cloud")
ax1.set_ylim([0.1,0.4])
ax1.set_xlim([40,70])
ax1.set_xticks([40,45,50,55,60,65,70])#, -0.1, 0, 0.1, 0.2])
ax1.set_yticks([0.1,0.2,0.3,0.4])
#ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f221[:,2]/Np,f121[:,2]/f21[:,2],color=color[1],lw=2,label='$r_d$$_1$ = 0.05$\mu$m')
ax2.plot(f222[:,2]/Np,f122[:,2]/f22[:,2],color=color[2],lw=1,label='$r_d$$_2$ = 0.07$\mu$m')
ax2.plot(f223[:,2]/Np,f123[:,2]/f23[:,2],color=color[3],lw=1,label='$r_d$$_3$ = 0.09$\mu$m')
ax2.plot(f224[:,2]/Np,f124[:,2]/f24[:,2],color=color[4],lw=1,label='$r_d$$_4$ = 0.1$\mu$m')
ax2.plot(f225[:,2]/Np,f125[:,2]/f25[:,2],color=color[5],lw=1,label='$r_d$$_5$ = 0.5$\mu$m')
ax2.plot(f226[:,2]/Np,f126[:,2]/f26[:,2],color=color[6],lw=1,linestyle='dotted',label='$r_d$$_6$ = 0.7$\mu$m')
ax2.plot(f227[:,2]/Np,f127[:,2]/f27[:,2],color=color[7],lw=1,linestyle='dashed',label='$r_d$$_7$ = 0.9$\mu$m')
#
ax2.set_ylabel(r"$\epsilon$",fontsize=14)
ax2.set_xlabel(r'NC(/cc)',fontsize=14)
#ax2.set_title("2nd Cloud")
ax2.set_ylim([0.1,0.4])
ax2.set_xlim([10,17])
ax2.set_xticks([10,11,12,13,14,15,16,17])#, -0.1, 0, 0.1, 0.2])
ax2.set_yticks([0.1,0.2,0.3,0.4])
#ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend1)
#plt.legend(bbox_to_anchor=(1.08,1.08), loc='upper left', borderaxespad=0.)
plt.tight_layout()
plt.savefig('NC_dispersion.png', dpi=300)
plt.show()
plt.close()
###################################################
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f311[:,1],f111[:,2]/f11[:,2],color=color[1],lw=2,label='$r_d1$')
ax1.plot(f312[:,1],f112[:,2]/f12[:,2],color=color[2],lw=1,label='$r_d2$')
ax1.plot(f313[:,1],f113[:,2]/f13[:,2],color=color[3],lw=1,label='$r_d3$')
ax1.plot(f314[:,1],f114[:,2]/f14[:,2],color=color[4],lw=1,label='$r_d4$')
ax1.plot(f315[:,1],f115[:,2]/f15[:,2],color=color[5],lw=1,label='$r_d5$')
ax1.plot(f316[:,1],f116[:,2]/f16[:,2],color=color[6],lw=1,linestyle='dotted',label='$r_d6$')
ax1.plot(f317[:,1],f117[:,2]/f17[:,2],color=color[7],lw=1,linestyle='dashed',label='$r_d7$')
ax1.set_ylabel(r'$\epsilon$',fontsize=14)
ax1.set_xlabel(r'LWC(gm/cc)',fontsize=14)
#ax1.set_title("1st cloud")
ax1.set_ylim([0.1,0.4])
ax1.set_xlim([1,4])
#ax1.set_xticks([40,45,50,55,60,65,70,75,80])#, -0.1, 0, 0.1, 0.2])
ax1.set_yticks([0.1,0.2,0.3,0.4])
#ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f321[:,1],f121[:,2]/f21[:,2],color=color[1],lw=2,label='$r_d$$_1$ = 0.05$\mu$m')
ax2.plot(f322[:,1],f122[:,2]/f22[:,2],color=color[2],lw=1,label='$r_d$$_2$ = 0.07$\mu$m')
ax2.plot(f323[:,1],f123[:,2]/f23[:,2],color=color[3],lw=1,label='$r_d$$_3$ = 0.09$\mu$m')
ax2.plot(f324[:,1],f124[:,2]/f24[:,2],color=color[4],lw=1,label='$r_d$$_4$ = 0.1$\mu$m')
ax2.plot(f325[:,1],f125[:,2]/f25[:,2],color=color[5],lw=1,label='$r_d$$_5$ = 0.5$\mu$m')
ax2.plot(f326[:,1],f126[:,2]/f26[:,2],color=color[6],lw=1,linestyle='dotted',label='$r_d$$_6$ = 0.7$\mu$m')
ax2.plot(f327[:,1],f127[:,2]/f27[:,2],color=color[7],lw=1,linestyle='dashed',label='$r_d$$_7$ = 0.9$\mu$m')
#
ax2.set_ylabel(r"$\epsilon$",fontsize=14)
ax2.set_xlabel(r'LWC(gm/cc)',fontsize=14)
#ax2.set_title("2nd Cloud")
ax2.set_ylim([0.1,0.4])
ax2.set_xlim([0,2.5])
#ax2.set_xticks([10,11,12,13,14,15,16,17,18])#, -0.1, 0, 0.1, 0.2])
ax2.set_yticks([0.1,0.2,0.3,0.4])
#ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend1)
#plt.legend(bbox_to_anchor=(1.08,1.08), loc='upper left', borderaxespad=0.)
plt.tight_layout()
plt.savefig('LWC_dispersion.png', dpi=300)
plt.show()
plt.close()
###################################################
###################################################
#
Np = 25.6**3
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f211[:,2]/Np,f311[:,1],color=color[1],lw=2,label='$r_d1$')
ax1.plot(f212[:,2]/Np,f312[:,1],color=color[2],lw=1,label='$r_d2$')
ax1.plot(f213[:,2]/Np,f313[:,1],color=color[3],lw=1,label='$r_d3$')
ax1.plot(f214[:,2]/Np,f314[:,1],color=color[4],lw=1,label='$r_d4$')
ax1.plot(f215[:,2]/Np,f315[:,1],color=color[5],lw=1,label='$r_d5$')
ax1.plot(f216[:,2]/Np,f316[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d6$')
ax1.plot(f217[:,2]/Np,f317[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d7$')
ax1.set_xlabel(r'NC(/cc)',fontsize=14)
ax1.set_ylabel(r'LWC(gm/cc)',fontsize=14)
#ax1.set_title("1st cloud")
ax1.set_xlim([40,80])
ax1.set_ylim([1,4])
ax1.set_xticks([40,45,50,55,60,65,70,75,80])#, -0.1, 0, 0.1, 0.2])
ax1.set_yticks([1,1.5,2,2.5,3,3.5,4])
#ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f221[:,2]/Np,f321[:,1],color=color[1],lw=2,label='$r_d$$_1$ = 0.05$\mu$m')
ax2.plot(f222[:,2]/Np,f322[:,1],color=color[2],lw=1,label='$r_d$$_2$ = 0.07$\mu$m')
ax2.plot(f223[:,2]/Np,f323[:,1],color=color[3],lw=1,label='$r_d$$_3$ = 0.09$\mu$m')
ax2.plot(f224[:,2]/Np,f324[:,1],color=color[4],lw=1,label='$r_d$$_4$ = 0.1$\mu$m')
ax2.plot(f225[:,2]/Np,f325[:,1],color=color[5],lw=1,label='$r_d$$_5$ = 0.5$\mu$m')
ax2.plot(f226[:,2]/Np,f326[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d$$_6$ = 0.7$\mu$m')
ax2.plot(f227[:,2]/Np,f327[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d$$_7$ = 0.9$\mu$m')
#
ax2.set_xlabel(r"NC(/cc)",fontsize=14)
ax2.set_ylabel(r'LWC(gm/cc)',fontsize=14)
#ax2.set_title("2nd Cloud")
ax2.set_xlim([10,18])
ax2.set_ylim([0,2.5])
ax2.set_xticks([10,11,12,13,14,15,16,17,18])#, -0.1, 0, 0.1, 0.2])
ax2.set_yticks([0,0.5,1,1.5,2,2.5])
#ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend1)
#plt.legend(bbox_to_anchor=(1.08,1.08), loc='upper left', borderaxespad=0.)
plt.tight_layout()
plt.savefig('LWC_NC.png', dpi=300)
plt.show()
plt.close()
###################################################
########## Hgt vs Droplet DSD##################################
#################rd1############################################
f11=np.loadtxt('./rd1_1st_cld/DSD/DSD_r_0000001.dat')
f12=np.loadtxt('./rd1_1st_cld/DSD/DSD_r_0800000.dat')
f13=np.loadtxt('./rd1_1st_cld/DSD/DSD_r_1600000.dat')
f14=np.loadtxt('./rd1_1st_cld/DSD/DSD_r_2400000.dat')
f15=np.loadtxt('./rd1_1st_cld/DSD/DSD_r_3150000.dat')
#
f21=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_0000001.dat')
f22=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_0400000.dat')
f23=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_0480000.dat')
f24=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_1200000.dat')
f25=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_2000000.dat')
f26=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_2800000.dat')
f27=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_3600000.dat')
f28=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_3950000.dat')
#
color=['m','r','b','k','g','orange','c','#f781bf', 'm']
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,0],f11[:,2],color=color[1],lw=1,label='H = 4 km')
ax1.plot(f12[:,0],f12[:,2],color=color[2],lw=1,label='H = 4.2 km')
ax1.plot(f13[:,0],f13[:,2],color=color[3],lw=1,label='H = 4.4 km')
ax1.plot(f14[:,0],f14[:,2],color=color[4],lw=1,label='H = 4.6 km')
ax1.plot(f15[:,0],f15[:,2],color=color[5],lw=1,label='H = 4.8 km',linestyle='dashed')
#ax1.plot(f16[:,0],f16[:,2],color=color[7],lw=1,label='H = 0 km',linestyle='dashed')
ax1.set_ylabel(r"log(PDF)",fontsize=10)
ax1.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax1.set_title("1st cloud")
ax1.set_xlim([0,50])
ax1.set_ylim([0,14])
ax1.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,10,20,30,40,50])
ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f21[:,0],f21[:,2],color=color[1],lw=1,label='H = 5.5 km')
ax2.plot(f22[:,0],f22[:,2],color=color[2],lw=1,label='H = 5.6 km')
ax2.plot(f23[:,0],f23[:,2],color=color[3],lw=1,label='H = 5.62 km')
ax2.plot(f24[:,0],f24[:,2],color=color[4],lw=1,label='H = 5.8 km')
ax2.plot(f25[:,0],f25[:,2],color=color[5],lw=1,label='H = 6 km')
ax2.plot(f26[:,0],f26[:,2],color=color[6],lw=1,label='H = 6.2 km',linestyle='dashed')
ax2.plot(f27[:,0],f27[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
#ax2.plot(f28[:,0],f28[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
ax2.set_ylabel(r"log(PDF)",fontsize=10)
ax2.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax2.set_title("2nd Cloud")
ax2.set_xlim([0,50])
ax2.set_ylim([0,14])
ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,10,20,30,40,50])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('rd1_Droplet_DSD.png', dpi=300)
plt.show()
plt.close()
################################################################
#################rd2############################################
f11=np.loadtxt('./rd2_1st_cld/DSD/DSD_r_0000001.dat')
f12=np.loadtxt('./rd2_1st_cld/DSD/DSD_r_0800000.dat')
f13=np.loadtxt('./rd2_1st_cld/DSD/DSD_r_1600000.dat')
f14=np.loadtxt('./rd2_1st_cld/DSD/DSD_r_2400000.dat')
f15=np.loadtxt('./rd2_1st_cld/DSD/DSD_r_3150000.dat')
#
f21=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_0000001.dat')
f22=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_0400000.dat')
f23=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_0480000.dat')
f24=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_1200000.dat')
f25=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_2000000.dat')
f26=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_2800000.dat')
f27=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_3600000.dat')
f28=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_3950000.dat')
#
color=['m','r','b','k','g','orange','c','#f781bf', 'm']
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,0],f11[:,2],color=color[1],lw=1,label='H = 4 km')
ax1.plot(f12[:,0],f12[:,2],color=color[2],lw=1,label='H = 4.2 km')
ax1.plot(f13[:,0],f13[:,2],color=color[3],lw=1,label='H = 4.4 km')
ax1.plot(f14[:,0],f14[:,2],color=color[4],lw=1,label='H = 4.6 km')
ax1.plot(f15[:,0],f15[:,2],color=color[5],lw=1,label='H = 4.8 km',linestyle='dashed')
#ax1.plot(f16[:,0],f16[:,2],color=color[7],lw=1,label='H = 0 km',linestyle='dashed')
ax1.set_ylabel(r"log(PDF)",fontsize=10)
ax1.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax1.set_title("1st cloud")
ax1.set_xlim([0,50])
ax1.set_ylim([0,14])
ax1.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,10,20,30,40,50])
ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
#
ax2.plot(f21[:,0],f21[:,2],color=color[1],lw=1,label='H = 5.5 km')
ax2.plot(f22[:,0],f22[:,2],color=color[2],lw=1,label='H = 5.6 km')
ax2.plot(f23[:,0],f23[:,2],color=color[3],lw=1,label='H = 5.62 km')
ax2.plot(f24[:,0],f24[:,2],color=color[4],lw=1,label='H = 5.8 km')
ax2.plot(f25[:,0],f25[:,2],color=color[5],lw=1,label='H = 6 km')
ax2.plot(f26[:,0],f26[:,2],color=color[6],lw=1,label='H = 6.2 km',linestyle='dashed')
ax2.plot(f27[:,0],f27[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
ax2.set_ylabel(r"log(PDF)",fontsize=10)
ax2.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax2.set_title("2nd Cloud")
ax2.set_xlim([0,50])
ax2.set_ylim([0,14])
ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,10,20,30,40,50])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('rd2_Droplet_DSD.png', dpi=300)
plt.show()
plt.close()
################################################################
#################rd3############################################
f11=np.loadtxt('./rd3_1st_cld/DSD/DSD_r_0000001.dat')
f12=np.loadtxt('./rd3_1st_cld/DSD/DSD_r_0800000.dat')
f13=np.loadtxt('./rd3_1st_cld/DSD/DSD_r_1600000.dat')
f14=np.loadtxt('./rd3_1st_cld/DSD/DSD_r_2400000.dat')
f15=np.loadtxt('./rd3_1st_cld/DSD/DSD_r_3150000.dat')
f15=np.loadtxt('./rd3_1st_cld/DSD/DSD_r_4000000.dat')
#
f21=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_0000001.dat')
#22=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_0400000.dat')
f22=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_0480000.dat')
f23=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_1200000.dat')
f24=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_2000000.dat')
f25=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_2800000.dat')
f26=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_3600000.dat')
f27=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_3950000.dat')
#
color=['m','r','b','k','g','orange','c','#f781bf', 'm']
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,0],f11[:,2],color=color[1],lw=1,label='H = 4 km')
ax1.plot(f12[:,0],f12[:,2],color=color[2],lw=1,label='H = 4.2 km')
ax1.plot(f13[:,0],f13[:,2],color=color[3],lw=1,label='H = 4.4 km')
ax1.plot(f14[:,0],f14[:,2],color=color[4],lw=1,label='H = 4.6 km')
ax1.plot(f15[:,0],f15[:,2],color=color[5],lw=1,label='H = 4.8 km',linestyle='dashed')
ax1.plot(f16[:,0],f16[:,2],color=color[7],lw=1,label='H = 5.0 km',linestyle='dashed')
ax1.set_ylabel(r"DSD",fontsize=12)
ax1.set_xlabel(r'D( $\mu$m)',fontsize=12)
#ax1.set_title("1st cloud")
ax1.set_xlim([0,50])
ax1.set_ylim([0,14])
ax1.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,10,20,30,40,50])
ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
#
ax2.plot(f21[:,0],f21[:,2],color=color[1],lw=1,label='H = 5.5 km')
#x2.plot(f22[:,0],f22[:,2],color=color[2],lw=1,label='H = 5.6 km')
ax2.plot(f23[:,0],f23[:,2],color=color[3],lw=1,label='H = 5.62 km')
ax2.plot(f24[:,0],f24[:,2],color=color[4],lw=1,label='H = 5.8 km')
ax2.plot(f25[:,0],f25[:,2],color=color[5],lw=1,label='H = 6 km')
ax2.plot(f26[:,0],f26[:,2],color=color[6],lw=1,label='H = 6.2 km',linestyle='dashed')
ax2.plot(f27[:,0],f27[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
ax2.set_ylabel(r"DSD",fontsize=12)
ax2.set_xlabel(r'D( $\mu$m)',fontsize=12)
#ax2.set_title("2nd Cloud")
ax2.set_xlim([0,50])
ax2.set_ylim([0,14])
ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,10,20,30,40,50])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('rd3_Droplet_DSD.png', dpi=300)
plt.show()
plt.close()
################################################################
#################rd4############################################
f11=np.loadtxt('./rd4_1st_cld/DSD/DSD_r_0000001.dat')
f12=np.loadtxt('./rd4_1st_cld/DSD/DSD_r_0800000.dat')
f13=np.loadtxt('./rd4_1st_cld/DSD/DSD_r_1600000.dat')
f14=np.loadtxt('./rd4_1st_cld/DSD/DSD_r_2400000.dat')
f15=np.loadtxt('./rd4_1st_cld/DSD/DSD_r_3150000.dat')
#
f21=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_0000001.dat')
f22=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_0400000.dat')
f23=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_0480000.dat')
f24=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_1200000.dat')
f25=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_2000000.dat')
f26=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_2800000.dat')
f27=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_3600000.dat')
f27=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_3950000.dat')
#
color=['m','r','b','k','g','orange','c','#f781bf', 'm']
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,0],f11[:,2],color=color[1],lw=1,label='H = 4 km')
ax1.plot(f12[:,0],f12[:,2],color=color[2],lw=1,label='H = 4.2 km')
ax1.plot(f13[:,0],f13[:,2],color=color[3],lw=1,label='H = 4.4 km')
ax1.plot(f14[:,0],f14[:,2],color=color[4],lw=1,label='H = 4.6 km')
ax1.plot(f15[:,0],f15[:,2],color=color[5],lw=1,label='H = 4.8 km',linestyle='dashed')
#ax1.plot(f16[:,0],f16[:,2],color=color[7],lw=1,label='H = 0 km',linestyle='dashed')
ax1.set_ylabel(r"log(PDF)",fontsize=10)
ax1.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax1.set_title("1st cloud")
ax1.set_xlim([0,50])
ax1.set_ylim([0,14])
ax1.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,10,20,30,40,50])
ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
#
ax2.plot(f21[:,0],f21[:,2],color=color[1],lw=1,label='H = 5.5 km')
ax2.plot(f22[:,0],f22[:,2],color=color[2],lw=1,label='H = 5.6 km')
ax2.plot(f23[:,0],f23[:,2],color=color[3],lw=1,label='H = 5.62 km')
ax2.plot(f24[:,0],f24[:,2],color=color[4],lw=1,label='H = 5.8 km')
ax2.plot(f25[:,0],f25[:,2],color=color[5],lw=1,label='H = 6 km')
ax2.plot(f26[:,0],f26[:,2],color=color[6],lw=1,label='H = 6.2 km',linestyle='dashed')
ax2.plot(f27[:,0],f27[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
ax2.set_ylabel(r"log(PDF)",fontsize=10)
ax2.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax2.set_title("2nd Cloud")
ax2.set_xlim([0,50])
ax2.set_ylim([0,14])
ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,10,20,30,40,50])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('rd4_Droplet_DSD.png', dpi=300)
plt.show()
plt.close()
################################################################
#################rd5############################################
f11=np.loadtxt('./rd5_1st_cld/DSD/DSD_r_0000001.dat')
f12=np.loadtxt('./rd5_1st_cld/DSD/DSD_r_0800000.dat')
f13=np.loadtxt('./rd5_1st_cld/DSD/DSD_r_1600000.dat')
f14=np.loadtxt('./rd5_1st_cld/DSD/DSD_r_2400000.dat')
f15=np.loadtxt('./rd5_1st_cld/DSD/DSD_r_3150000.dat')
#
f21=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_0000001.dat')
f22=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_0400000.dat')
f23=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_0480000.dat')
f24=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_1200000.dat')
f25=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_2000000.dat')
f26=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_2800000.dat')
f27=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_3600000.dat')
f27=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_3950000.dat')
#
color=['m','r','b','k','g','orange','c','#f781bf', 'm']
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,0],f11[:,2],color=color[1],lw=1,label='H = 4 km')
ax1.plot(f12[:,0],f12[:,2],color=color[2],lw=1,label='H = 4.2 km')
ax1.plot(f13[:,0],f13[:,2],color=color[3],lw=1,label='H = 4.4 km')
ax1.plot(f14[:,0],f14[:,2],color=color[4],lw=1,label='H = 4.6 km')
ax1.plot(f15[:,0],f15[:,2],color=color[5],lw=1,label='H = 4.8 km',linestyle='dashed')
#ax1.plot(f16[:,0],f16[:,2],color=color[7],lw=1,label='H = 0 km',linestyle='dashed')
ax1.set_ylabel(r"log(PDF)",fontsize=10)
ax1.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax1.set_title("1st cloud")
ax1.set_xlim([0,50])
ax1.set_ylim([0,14])
ax1.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,10,20,30,40,50])
ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
#
ax2.plot(f21[:,0],f21[:,2],color=color[1],lw=1,label='H = 5.5 km')
ax2.plot(f22[:,0],f22[:,2],color=color[2],lw=1,label='H = 5.6 km')
ax2.plot(f23[:,0],f23[:,2],color=color[3],lw=1,label='H = 5.62 km')
ax2.plot(f24[:,0],f24[:,2],color=color[4],lw=1,label='H = 5.8 km')
ax2.plot(f25[:,0],f25[:,2],color=color[5],lw=1,label='H = 6 km')
ax2.plot(f26[:,0],f26[:,2],color=color[6],lw=1,label='H = 6.2 km',linestyle='dashed')
ax2.plot(f27[:,0],f27[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
ax2.set_ylabel(r"log(PDF)",fontsize=10)
ax2.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax2.set_title("2nd Cloud")
ax2.set_xlim([0,50])
ax2.set_ylim([0,14])
ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,10,20,30,40,50])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('rd5_Droplet_DSD.png', dpi=300)
plt.show()
plt.close()
################################################################
#################rd6############################################
f11=np.loadtxt('./rd6_1st_cld/DSD/DSD_r_0000001.dat')
f12=np.loadtxt('./rd6_1st_cld/DSD/DSD_r_0800000.dat')
f13=np.loadtxt('./rd6_1st_cld/DSD/DSD_r_1600000.dat')
f14=np.loadtxt('./rd6_1st_cld/DSD/DSD_r_2400000.dat')
f15=np.loadtxt('./rd6_1st_cld/DSD/DSD_r_3150000.dat')
#
f21=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_0000001.dat')
f22=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_0400000.dat')
f23=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_0480000.dat')
f24=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_1200000.dat')
f25=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_2000000.dat')
f26=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_2800000.dat')
f27=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_3600000.dat')
f27=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_3950000.dat')
#
color=['m','r','b','k','g','orange','c','#f781bf', 'm']
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,0],f11[:,2],color=color[1],lw=1,label='H = 4 km')
ax1.plot(f12[:,0],f12[:,2],color=color[2],lw=1,label='H = 4.2 km')
ax1.plot(f13[:,0],f13[:,2],color=color[3],lw=1,label='H = 4.4 km')
ax1.plot(f14[:,0],f14[:,2],color=color[4],lw=1,label='H = 4.6 km')
ax1.plot(f15[:,0],f15[:,2],color=color[5],lw=1,label='H = 4.8 km',linestyle='dashed')
#ax1.plot(f16[:,0],f16[:,2],color=color[7],lw=1,label='H = 0 km',linestyle='dashed')
ax1.set_ylabel(r"log(PDF)",fontsize=10)
ax1.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax1.set_title("1st cloud")
ax1.set_xlim([0,50])
ax1.set_ylim([0,14])
ax1.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,10,20,30,40,50])
ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
#
ax2.plot(f21[:,0],f21[:,2],color=color[1],lw=1,label='H = 5.5 km')
ax2.plot(f22[:,0],f22[:,2],color=color[2],lw=1,label='H = 5.6 km')
ax2.plot(f23[:,0],f23[:,2],color=color[3],lw=1,label='H = 5.62 km')
ax2.plot(f24[:,0],f24[:,2],color=color[4],lw=1,label='H = 5.8 km')
ax2.plot(f25[:,0],f25[:,2],color=color[5],lw=1,label='H = 6 km')
ax2.plot(f26[:,0],f26[:,2],color=color[6],lw=1,label='H = 6.2 km',linestyle='dashed')
ax2.plot(f27[:,0],f27[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
ax2.set_ylabel(r"log(PDF)",fontsize=10)
ax2.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax2.set_title("2nd Cloud")
ax2.set_xlim([0,50])
ax2.set_ylim([0,14])
ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,10,20,30,40,50])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('rd6_Droplet_DSD.png', dpi=300)
plt.show()
plt.close()
################################################################
#################rd7############################################
f11=np.loadtxt('./rd7_1st_cld/DSD/DSD_r_0000001.dat')
f12=np.loadtxt('./rd7_1st_cld/DSD/DSD_r_0800000.dat')
f13=np.loadtxt('./rd7_1st_cld/DSD/DSD_r_1600000.dat')
f14=np.loadtxt('./rd7_1st_cld/DSD/DSD_r_2400000.dat')
f15=np.loadtxt('./rd7_1st_cld/DSD/DSD_r_3150000.dat')
#
f21=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_0000001.dat')
f22=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_0400000.dat')
f23=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_0480000.dat')
f24=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_1200000.dat')
f25=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_2000000.dat')
f26=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_2800000.dat')
#f27=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_3600000.dat')
#f28=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_3950000.dat')
#
color=['m','r','b','k','g','orange','c','#f781bf', 'm']
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,0],f11[:,2],color=color[1],lw=1,label='H = 4 km')
ax1.plot(f12[:,0],f12[:,2],color=color[2],lw=1,label='H = 4.2 km')
ax1.plot(f13[:,0],f13[:,2],color=color[3],lw=1,label='H = 4.4 km')
ax1.plot(f14[:,0],f14[:,2],color=color[4],lw=1,label='H = 4.6 km')
ax1.plot(f15[:,0],f15[:,2],color=color[5],lw=1,label='H = 4.8 km',linestyle='dashed')
#ax1.plot(f16[:,0],f16[:,2],color=color[7],lw=1,label='H = 0 km',linestyle='dashed')
ax1.set_ylabel(r"log(PDF)",fontsize=10)
ax1.set_xlabel(r'D($\mu$m)',fontsize=12)
ax1.set_title("1st cloud")
ax1.set_xlim([0,50])
ax1.set_ylim([0,14])
ax1.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,10,20,30,40,50])
ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
#
ax2.plot(f21[:,0],f21[:,2],color=color[1],lw=1,label='H = 5.5 km')
ax2.plot(f22[:,0],f22[:,2],color=color[2],lw=1,label='H = 5.6 km')
ax2.plot(f23[:,0],f23[:,2],color=color[3],lw=1,label='H = 5.62 km')
ax2.plot(f24[:,0],f24[:,2],color=color[4],lw=1,label='H = 5.8 km')
ax2.plot(f25[:,0],f25[:,2],color=color[5],lw=1,label='H = 6 km')
ax2.plot(f26[:,0],f26[:,2],color=color[6],lw=1,label='H = 6.2 km',linestyle='dashed')
#ax2.plot(f27[:,0],f27[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
ax2.set_ylabel(r"log(PDF)",fontsize=10)
ax2.set_xlabel(r'D($\mu$m)',fontsize=12)
ax2.set_title("2nd Cloud")
ax2.set_xlim([0,50])
ax2.set_ylim([0,14])
ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,10,20,30,40,50])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('rd7_Droplet_DSD.png', dpi=300)
plt.show()
plt.close()
################################################################

