#=====================================================================
import numpy as np
import math
import matplotlib.pyplot as plt
#import matplotlib as plt
from matplotlib import rc
#import csv
#====================Plotting ==========================================
import matplotlib.pyplot as plt

from matplotlib import rc

rc('text',usetex=True)
font = {'size'   : 15}
rc('font', **font)
#
color=['b','r','k','g','orange','c','b','#f781bf']
################################################################
########## Hgt vs Droplet DSD##################################
#################rd1############################################
f11=np.loadtxt('./rd1_1st_cld/DSD/DSD_r_0000001.dat')
#
f21=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_0000001.dat')
#
#color=['m','r','b','k','g','orange','c','#f781bf', 'm']
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,0],f11[:,2],color=color[1],lw=2,label='Height= 2.5 km')
ax1.set_ylabel(r"DSD",fontsize=10)
ax1.set_xlabel(r'D($\mu$m)',fontsize=12)
#ax1.set_title("1st cloud")
ax1.set_xlim([0,40])
ax1.set_ylim([0,14])
ax1.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,10,20,30,40])
#ax1.legend(loc='upper right',prop={'size':9.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f21[:,0],f21[:,2],color=color[1],lw=2,label='Height = 4 km')
#ax2.plot(f28[:,0],f28[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
ax2.set_ylabel(r"DSD",fontsize=10)
ax2.set_xlabel(r'D( $\mu$m)',fontsize=12)
#ax2.set_title("2nd Cloud")
ax2.set_xlim([0,40])
ax2.set_ylim([0,14])
#ax2.legend(loc='upper right',prop={'size':9.5},frameon=False)
ax2.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,10,20,30,40])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('New_Initial_DSD.png', dpi=300)
plt.show()
plt.close()
###############################################################
#-----------------1st cloud--------------------------------
f11=np.loadtxt('./rd1_1st_cld/r_mean.dat')
f12=np.loadtxt('./rd2_1st_cld/r_mean.dat')
f13=np.loadtxt('./rd3_1st_cld/r_mean.dat')
f14=np.loadtxt('./rd4_1st_cld/r_mean.dat')
f15=np.loadtxt('./rd5_1st_cld/r_mean.dat')
f16=np.loadtxt('./rd6_1st_cld/r_mean.dat')
f17=np.loadtxt('./rd7_1st_cld/r_mean.dat')
#-----------------2nd cloud--------------------------------
f21=np.loadtxt('./rd1_2nd_cld/r_mean.dat')
f22=np.loadtxt('./rd2_2nd_cld/r_mean.dat')
f23=np.loadtxt('./rd3_2nd_cld/r_mean.dat')
f24=np.loadtxt('./rd4_2nd_cld/r_mean.dat')
f25=np.loadtxt('./rd5_2nd_cld/r_mean.dat')
f26=np.loadtxt('./rd6_2nd_cld/r_mean.dat')
f27=np.loadtxt('./rd7_2nd_cld/r_mean.dat')
#-----------------1st cloud--------------------------------
f111=np.loadtxt('./rd1_1st_cld/r_stand_div.dat')
f112=np.loadtxt('./rd2_1st_cld/r_stand_div.dat')
f113=np.loadtxt('./rd3_1st_cld/r_stand_div.dat')
f114=np.loadtxt('./rd4_1st_cld/r_stand_div.dat')
f115=np.loadtxt('./rd5_1st_cld/r_stand_div.dat')
f116=np.loadtxt('./rd6_1st_cld/r_stand_div.dat')
f117=np.loadtxt('./rd7_1st_cld/r_stand_div.dat')
#-----------------2nd cloud--------------------------------
f121=np.loadtxt('./rd1_2nd_cld/r_stand_div.dat')
f122=np.loadtxt('./rd2_2nd_cld/r_stand_div.dat')
f123=np.loadtxt('./rd3_2nd_cld/r_stand_div.dat')
f124=np.loadtxt('./rd4_2nd_cld/r_stand_div.dat')
f125=np.loadtxt('./rd5_2nd_cld/r_stand_div.dat')
f126=np.loadtxt('./rd6_2nd_cld/r_stand_div.dat')
f127=np.loadtxt('./rd7_2nd_cld/r_stand_div.dat')
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f111[:,2]/f11[:,2],f11[:,1],color=color[1],lw=2,label='$r_d1$')
ax1.plot(f112[:,2]/f12[:,2] ,f12[:,1],color=color[2],lw=1,label='$r_d2$')
ax1.plot(f113[:,2]/f13[:,2] ,f13[:,1],color=color[3],lw=1,label='$r_d3$')
ax1.plot(f114[:,2]/f14[:,2] ,f14[:,1],color=color[4],lw=1,label='$r_d4$')
ax1.plot(f115[:,2]/f15[:,2] ,f15[:,1],color=color[5],lw=1,label='$r_d5$')
ax1.plot(f116[:,2]/f16[:,2] ,f16[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d6$')
ax1.plot(f117[:,2]/f17[:,2] ,f17[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d7$')
ax1.set_xlabel(r'$\epsilon= \sigma/D_m$',fontsize=14)
ax1.set_ylabel(r'H(Km)',fontsize=14)
#ax1.set_title("1st cloud")
ax1.set_xlim([0,0.4])
ax1.set_ylim([4,5])
ax1.set_yticks([4,4.2,4.4,4.6,4.8,5.0])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,0.1,0.2,0.3,0.4])
#ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f121[:,2]/f21[:,2] ,f21[:,1],color=color[1],lw=2,label='$r_d$$_1$ = 0.05$\mu$m')
ax2.plot(f122[:,2]/f22[:,2] ,f22[:,1],color=color[2],lw=1,label='$r_d$$_2$ = 0.07$\mu$m')
ax2.plot(f123[:,2]/f23[:,2] ,f23[:,1],color=color[3],lw=1,label='$r_d$$_3$ = 0.09$\mu$m')
ax2.plot(f124[:,2]/f24[:,2] ,f24[:,1],color=color[4],lw=1,label='$r_d$$_4$ = 0.1$\mu$m')
ax2.plot(f125[:,2]/f25[:,2] ,f25[:,1],color=color[5],lw=1,label='$r_d$$_5$ = 0.5$\mu$m')
ax2.plot(f126[:,2]/f26[:,2] ,f26[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d$$_6$ = 0.7$\mu$m')
ax2.plot(f127[:,2]/f27[:,2] ,f27[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d$$_7$ = 0.9$\mu$m')
#
ax2.set_xlabel(r"$\epsilon= \sigma/D_m$",fontsize=14)
ax2.set_ylabel(r'H(km)',fontsize=14)
#ax2.set_title("2nd Cloud")
ax2.set_xlim([0,0.4])
ax2.set_ylim([5.5,6.5])
ax2.set_yticks([5.5,5.7,5.9,6.1,6.3,6.5])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,0.1,0.2,0.3,0.4])
#ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend1)
plt.legend(bbox_to_anchor=(1.08,1.08), loc='upper left', borderaxespad=0.)
plt.tight_layout()
plt.savefig('1_epsilon.png', dpi=300)
plt.show()
plt.close()
###################################################


###################Hgt vs Pe##############################################
#-----------------1st cloud--------------------------------
f11=np.loadtxt('./rd1_1st_cld/Time_Hgt_Pe.dat')
f12=np.loadtxt('./rd2_1st_cld/Time_Hgt_Pe.dat')
f13=np.loadtxt('./rd3_1st_cld/Time_Hgt_Pe.dat')
f14=np.loadtxt('./rd4_1st_cld/Time_Hgt_Pe.dat')
f15=np.loadtxt('./rd5_1st_cld/Time_Hgt_Pe.dat')
f16=np.loadtxt('./rd6_1st_cld/Time_Hgt_Pe.dat')
f17=np.loadtxt('./rd7_1st_cld/Time_Hgt_Pe.dat')
#-----------------2nd cloud--------------------------------
f21=np.loadtxt('./rd1_2nd_cld/Time_Hgt_Pe.dat')
f22=np.loadtxt('./rd2_2nd_cld/Time_Hgt_Pe.dat')
f23=np.loadtxt('./rd3_2nd_cld/Time_Hgt_Pe.dat')
f24=np.loadtxt('./rd4_2nd_cld/Time_Hgt_Pe.dat')
f25=np.loadtxt('./rd5_2nd_cld/Time_Hgt_Pe.dat')
f26=np.loadtxt('./rd6_2nd_cld/Time_Hgt_Pe.dat')
f27=np.loadtxt('./rd7_2nd_cld/Time_Hgt_Pe.dat')
#f2=np.loadtxt('./2nd_cloud_Sim1/Time_Hgt_Pe.dat')
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,2] ,f11[:,1],color=color[1],lw=2,label='$r_d1$')
ax1.plot(f12[:,2] ,f12[:,1],color=color[2],lw=1,label='$r_d2$')
ax1.plot(f13[:,2] ,f13[:,1],color=color[3],lw=1,label='$r_d3$')
ax1.plot(f14[:,2] ,f14[:,1],color=color[4],lw=1,label='$r_d4$')
ax1.plot(f15[:,2] ,f15[:,1],color=color[5],lw=1,label='$r_d5$')
ax1.plot(f16[:,2] ,f16[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d6$')
ax1.plot(f17[:,2] ,f17[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d7$')
ax1.set_xlabel(r'P(hPa)',fontsize=14)
ax1.set_ylabel(r'H(Km)',fontsize=14)
#ax1.set_title("1st cloud")
ax1.set_xlim([530,600])
ax1.set_ylim([4,5])
ax1.set_yticks([4,4.2,4.4,4.6,4.8,5.0])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([530, 540, 550, 560,570, 580, 590,600])
#ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f21[:,2] ,f21[:,1],color=color[1],lw=2,label='$r_d$$_1$ = 0.05$\mu$m')
ax2.plot(f22[:,2] ,f22[:,1],color=color[2],lw=1,label='$r_d$$_2$ = 0.07$\mu$m')
ax2.plot(f23[:,2] ,f23[:,1],color=color[3],lw=1,label='$r_d$$_3$ = 0.09$\mu$m')
ax2.plot(f24[:,2] ,f24[:,1],color=color[4],lw=1,label='$r_d$$_4$ = 0.1$\mu$m')
ax2.plot(f25[:,2] ,f25[:,1],color=color[5],lw=1,label='$r_d$$_5$ = 0.5$\mu$m')
ax2.plot(f26[:,2] ,f26[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d$$_6$ = 0.7$\mu$m')
ax2.plot(f27[:,2] ,f27[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d$$_7$ = 0.9$\mu$m')
#
ax2.set_xlabel(r'P(hPa)',fontsize=14)
ax2.set_ylabel(r'H(Km)',fontsize=14)
#ax2.set_title("2nd Cloud")
ax2.set_xlim([430,500])
ax2.set_ylim([5.5,6.5])
ax2.set_yticks([5.5,5.7,5.9,6.1,6.3,6.5])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([430,440, 450,460,470,480,490,500])
#ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
plt.legend(bbox_to_anchor=(1.08,1.08), loc='upper left', borderaxespad=0.)
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('Hgt_Pe.png', dpi=300)
plt.show()
plt.close()

###################Hgt vs Tc##############################################
#-----------------1st cloud--------------------------------
f11=np.loadtxt('./rd1_1st_cld/Time_Hgt_Tc.dat')
f12=np.loadtxt('./rd2_1st_cld/Time_Hgt_Tc.dat')
f13=np.loadtxt('./rd3_1st_cld/Time_Hgt_Tc.dat')
f14=np.loadtxt('./rd4_1st_cld/Time_Hgt_Tc.dat')
f15=np.loadtxt('./rd5_1st_cld/Time_Hgt_Tc.dat')
f16=np.loadtxt('./rd6_1st_cld/Time_Hgt_Tc.dat')
f17=np.loadtxt('./rd7_1st_cld/Time_Hgt_Tc.dat')
#-----------------2nd cloud--------------------------------
f21=np.loadtxt('./rd1_2nd_cld/Time_Hgt_Tc.dat')
f22=np.loadtxt('./rd2_2nd_cld/Time_Hgt_Tc.dat')
f23=np.loadtxt('./rd3_2nd_cld/Time_Hgt_Tc.dat')
f24=np.loadtxt('./rd4_2nd_cld/Time_Hgt_Tc.dat')
f25=np.loadtxt('./rd5_2nd_cld/Time_Hgt_Tc.dat')
f26=np.loadtxt('./rd6_2nd_cld/Time_Hgt_Tc.dat')
f27=np.loadtxt('./rd7_2nd_cld/Time_Hgt_Tc.dat')
#f1=np.loadtxt('./1st_cloud_Sim1/Time_Hgt_Tc.dat')
#f2=np.loadtxt('./2nd_cloud_Sim1/Time_Hgt_Tc.dat')
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,2] ,f11[:,1],color=color[1],lw=2,label='$r_d1$')
ax1.plot(f12[:,2] ,f12[:,1],color=color[2],lw=1,label='$r_d2$')
ax1.plot(f13[:,2] ,f13[:,1],color=color[3],lw=1,label='$r_d3$')
ax1.plot(f14[:,2] ,f14[:,1],color=color[4],lw=1,label='$r_d4$')
ax1.plot(f15[:,2] ,f15[:,1],color=color[5],lw=1,label='$r_d5$')
ax1.plot(f16[:,2] ,f16[:,1],color=color[6],linestyle='dotted',lw=1,label='$r_d6$')
ax1.plot(f17[:,2] ,f17[:,1],color=color[7],linestyle='dashed',lw=1,label='$r_d7$')
#ax1.plot(f1[:,2] ,f1[:,1],color=color[2],lw=1)#,label='$P$')
ax1.set_xlabel(r'T(K)',fontsize=14)
ax1.set_ylabel(r'H(Km)',fontsize=14)
#ax1.set_title("1st cloud")
ax1.set_xlim([283,289])
ax1.set_ylim([4,5])
ax1.set_yticks([4,4.2,4.4,4.6,4.8,5.0])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([283,285,287,289])
#ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f21[:,2] ,f21[:,1],color=color[1],lw=2,label='$r_d$$_1$ = 0.05$\mu$m')
ax2.plot(f22[:,2] ,f22[:,1],color=color[2],lw=1,label='$r_d$$_2$ = 0.07$\mu$m')
ax2.plot(f23[:,2] ,f23[:,1],color=color[3],lw=1,label='$r_d$$_1$ = 0.09$\mu$m')
ax2.plot(f24[:,2] ,f24[:,1],color=color[4],lw=1,label='$r_d$$_1$ = 0.1$\mu$m')
ax2.plot(f25[:,2] ,f25[:,1],color=color[5],lw=1,label='$r_d$$_1$ = 0.5$\mu$m')
ax2.plot(f26[:,2] ,f26[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d$$_1$ = 0.7$\mu$m')
ax2.plot(f27[:,2] ,f27[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d$$_1$ = 0.9$\mu$m')
#
#ax2.plot(f2[:,2] ,f2[:,1],color=color[3],lw=1)#,label='$P$')
ax2.set_xlabel(r'T (K)',fontsize=14)
ax2.set_ylabel(r'H(Km)',fontsize=14)
#ax2.set_title("2nd Cloud")
ax2.set_xlim([276,284])
ax2.set_ylim([5.5,6.5])
ax2.set_yticks([5.5,5.7,5.9,6.1,6.3,6.5])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([276,278,280,282,284])
#ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend1)
plt.legend(bbox_to_anchor=(1.08,1.08), loc='upper left', borderaxespad=0.)
plt.tight_layout()
plt.savefig('Hgt_T.png', dpi=300)
plt.show()
plt.close()

########## Hgt vs Wz##################################
f1=np.loadtxt('./rd1_1st_cld/Time_Hgt_Wz.dat')
f2=np.loadtxt('./rd1_2nd_cld/Time_Hgt_Wz.dat')
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f1[:,2]/100,f1[:,1],color=color[3],lw=1)#,label='$P$')
ax1.set_xlabel(r'$w_z$(m/s)',fontsize=14)
ax1.set_ylabel(r'H(Km)',fontsize=14)
#ax1.set_title("1st cloud")
ax1.set_xlim([0,1])
ax1.set_ylim([4,5])
ax1.set_yticks([4,4.2,4.4,4.6,4.8,5.0])#, -0.1, 0, 0.1, 0.2])
#ax1.set_xticks([283,285,287,289])
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f2[:,2]/100,f2[:,1],color=color[3],lw=1)#,label='$P$')
ax2.set_xlabel(r'$w_z$(m/s)',fontsize=14)
ax2.set_ylabel(r'H(Km)',fontsize=14)
#ax2.set_title("2nd Cloud")
ax2.set_xlim([0,1])
ax2.set_ylim([5.5,6.5])
ax2.set_yticks([5.5,5.7,5.9,6.1,6.3,6.5])#, -0.1, 0, 0.1, 0.2])
#ax2.set_xticks([276,278,280,282,284])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend1)
plt.tight_layout()
plt.savefig('Hgt_Wz.png', dpi=300)
plt.show()
plt.close()
########## Hgt vs mean radius##################################
#-----------------1st cloud--------------------------------
f11=np.loadtxt('./rd1_1st_cld/r_mean.dat')
f12=np.loadtxt('./rd2_1st_cld/r_mean.dat')
f13=np.loadtxt('./rd3_1st_cld/r_mean.dat')
f14=np.loadtxt('./rd4_1st_cld/r_mean.dat')
f15=np.loadtxt('./rd5_1st_cld/r_mean.dat')
f16=np.loadtxt('./rd6_1st_cld/r_mean.dat')
f17=np.loadtxt('./rd7_1st_cld/r_mean.dat')
#-----------------2nd cloud--------------------------------
f21=np.loadtxt('./rd1_2nd_cld/r_mean.dat')
f22=np.loadtxt('./rd2_2nd_cld/r_mean.dat')
f23=np.loadtxt('./rd3_2nd_cld/r_mean.dat')
f24=np.loadtxt('./rd4_2nd_cld/r_mean.dat')
f25=np.loadtxt('./rd5_2nd_cld/r_mean.dat')
f26=np.loadtxt('./rd6_2nd_cld/r_mean.dat')
f27=np.loadtxt('./rd7_2nd_cld/r_mean.dat')
#
#f1=np.loadtxt('./1st_cloud_Sim1/r_mean.dat')
#f2=np.loadtxt('./2nd_cloud_Sim1/r_mean.dat')
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,2] ,f11[:,1],color=color[1],lw=2,label='$r_d1$')
ax1.plot(f12[:,2] ,f12[:,1],color=color[2],lw=1,label='$r_d2$')
ax1.plot(f13[:,2] ,f13[:,1],color=color[3],lw=1,label='$r_d3$')
ax1.plot(f14[:,2] ,f14[:,1],color=color[4],lw=1,label='$r_d4$')
ax1.plot(f15[:,2] ,f15[:,1],color=color[5],lw=1,label='$r_d5$')
ax1.plot(f16[:,2] ,f16[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d$$_1$ = 0.7$\mu$m')
ax1.plot(f17[:,2] ,f17[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d$$_1$ = 0.9$\mu$m')
#ax1.plot(f1[:,2],f1[:,1],color=color[2],lw=1)#,label='$P$')
ax1.set_xlabel(r"$D_m($ $\mu$m)",fontsize=14)
ax1.set_ylabel(r'H(km)',fontsize=14)
#ax1.set_title("1st cloud")
ax1.set_xlim([14,26])
ax1.set_ylim([4,5])
#ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.set_yticks([4,4.2,4.4,4.6,4.8,5.0])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([14,16,18,20,22,24,26])
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f21[:,2] ,f21[:,1],color=color[1],lw=2,label='$r_d$$_1$ = 0.05$\mu$m')
ax2.plot(f22[:,2] ,f22[:,1],color=color[2],lw=1,label='$r_d$$_2$ = 0.07$\mu$m')
ax2.plot(f23[:,2] ,f23[:,1],color=color[3],lw=1,label='$r_d$$_3$ = 0.09$\mu$m')
ax2.plot(f24[:,2] ,f24[:,1],color=color[4],lw=1,label='$r_d$$_4$ = 0.1$\mu$m')
ax2.plot(f25[:,2] ,f25[:,1],color=color[5],lw=1,label='$r_d$$_5$ = 0.5$\mu$m')
ax2.plot(f26[:,2] ,f26[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d$$_6$ = 0.7$\mu$m')
ax2.plot(f27[:,2] ,f27[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d$$_7$ = 0.9$\mu$m')
#ax2.plot(f2[:,2],f2[:,1],color=color[3],lw=1)#,label='$P$')
ax2.set_xlabel(r"$D_m($ $\mu$m)",fontsize=14)
ax2.set_ylabel(r'H(km)',fontsize=14)
#ax2.set_title("2nd Cloud")
ax2.set_xlim([14,26])
ax2.set_ylim([5.5,6.5])
ax2.set_yticks([5.5,5.7,5.9,6.1,6.3,6.5])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([14,16,18,20,22,24,26])
#ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend1)
#plt.legend(bbox_to_anchor=(1.08,1.08), loc='upper left', borderaxespad=0.)
plt.tight_layout()
plt.savefig('mean_radius.png', dpi=300)
plt.show()
plt.close()
########## Hgt vs Number concentration##################################
#-----------------1st cloud--------------------------------
f11=np.loadtxt('./rd1_1st_cld/r_Num_Con.dat')
f12=np.loadtxt('./rd2_1st_cld/r_Num_Con.dat')
f13=np.loadtxt('./rd3_1st_cld/r_Num_Con.dat')
f14=np.loadtxt('./rd4_1st_cld/r_Num_Con.dat')
f15=np.loadtxt('./rd5_1st_cld/r_Num_Con.dat')
f16=np.loadtxt('./rd6_1st_cld/r_Num_Con.dat')
f17=np.loadtxt('./rd7_1st_cld/r_Num_Con.dat')
#-----------------2nd cloud--------------------------------
f21=np.loadtxt('./rd1_2nd_cld/r_Num_Con.dat')
f22=np.loadtxt('./rd2_2nd_cld/r_Num_Con.dat')
f23=np.loadtxt('./rd3_2nd_cld/r_Num_Con.dat')
f24=np.loadtxt('./rd4_2nd_cld/r_Num_Con.dat')
f25=np.loadtxt('./rd5_2nd_cld/r_Num_Con.dat')
f26=np.loadtxt('./rd6_2nd_cld/r_Num_Con.dat')
f27=np.loadtxt('./rd7_2nd_cld/r_Num_Con.dat')

#f1=np.loadtxt('./1st_cloud_Sim1/r_Num_Con.dat')
#f2=np.loadtxt('./2nd_cloud_Sim1/r_Num_Con.dat')
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
Np = 25.6**3
#
ax1.plot(f11[:,2]/Np ,f11[:,1],color=color[1],lw=2,label='$r_d1$')
ax1.plot(f12[:,2]/Np ,f12[:,1],color=color[2],lw=1,label='$r_d2$')
ax1.plot(f13[:,2]/Np ,f13[:,1],color=color[3],lw=1,label='$r_d3$')
ax1.plot(f14[:,2]/Np ,f14[:,1],color=color[4],lw=1,label='$r_d4$')
ax1.plot(f15[:,2]/Np ,f15[:,1],color=color[5],lw=1,label='$r_d5$')
ax1.plot(f16[:,2]/Np ,f16[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d6$')
ax1.plot(f17[:,2]/Np ,f17[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d7$')
#ax1.plot(f1[:,2]/Np,f1[:,1],color=color[2],lw=1)#,label='$P$')
ax1.set_xlabel(r"NC(/cc)",fontsize=14)
ax1.set_ylabel(r'H(km)',fontsize=14)
#ax1.set_title("1st cloud")
ax1.set_xlim([40,80])
ax1.set_ylim([4,5])
ax1.set_yticks([4,4.2,4.4,4.6,4.8,5])#, -0.1, 0, 0.1, 0.2])
#ax1.set_xticks([14,16,18,20,22,24,26])
#ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f21[:,2]/Np ,f21[:,1],color=color[1],lw=2,label='$r_d$$_1$ = 0.05$\mu$m')
ax2.plot(f22[:,2]/Np ,f22[:,1],color=color[2],lw=1,label='$r_d$$_2$ = 0.07$\mu$m')
ax2.plot(f23[:,2]/Np ,f23[:,1],color=color[3],lw=1,label='$r_d$$_3$ = 0.09$\mu$m')
ax2.plot(f24[:,2]/Np ,f24[:,1],color=color[4],lw=1,label='$r_d$$_4$ = 0.1$\mu$m')
ax2.plot(f25[:,2]/Np ,f25[:,1],color=color[5],lw=1,label='$r_d$$_5$ = 0.5$\mu$m')
ax2.plot(f26[:,2]/Np ,f26[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d$$_6$ = 0.7$\mu$m')
ax2.plot(f27[:,2]/Np ,f27[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d$$_7$ = 0.9$\mu$m')
#ax2.plot(f2[:,2]/Np,f2[:,1],color=color[3],lw=1)#,label='$P$')
ax2.set_xlabel(r"NC(/cc)",fontsize=14)
ax2.set_ylabel(r'H(km)',fontsize=14)
#ax2.set_title("2nd Cloud")
ax2.set_xlim([10,18])
ax2.set_ylim([5.5,6.5])
ax2.set_yticks([5.5,5.7,5.9,6.1,6.3,6.5])#, -0.1, 0, 0.1, 0.2])
#ax2.set_xticks([14,16,18,20,22,24,26])
#ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend1)
#plt.legend(bbox_to_anchor=(1.08,1.08), loc='upper left', borderaxespad=0.)
plt.tight_layout()
plt.savefig('Number_concentration.png', dpi=300)
plt.show()
plt.close()
########## Hgt vs Standard Deviation##################################
#-----------------1st cloud--------------------------------
f11=np.loadtxt('./rd1_1st_cld/r_stand_div.dat')
f12=np.loadtxt('./rd2_1st_cld/r_stand_div.dat')
f13=np.loadtxt('./rd3_1st_cld/r_stand_div.dat')
f14=np.loadtxt('./rd4_1st_cld/r_stand_div.dat')
f15=np.loadtxt('./rd5_1st_cld/r_stand_div.dat')
f16=np.loadtxt('./rd6_1st_cld/r_stand_div.dat')
f17=np.loadtxt('./rd7_1st_cld/r_stand_div.dat')
#-----------------2nd cloud--------------------------------
f21=np.loadtxt('./rd1_2nd_cld/r_stand_div.dat')
f22=np.loadtxt('./rd2_2nd_cld/r_stand_div.dat')
f23=np.loadtxt('./rd3_2nd_cld/r_stand_div.dat')
f24=np.loadtxt('./rd4_2nd_cld/r_stand_div.dat')
f25=np.loadtxt('./rd5_2nd_cld/r_stand_div.dat')
f26=np.loadtxt('./rd6_2nd_cld/r_stand_div.dat')
f27=np.loadtxt('./rd7_2nd_cld/r_stand_div.dat')

#f1=np.loadtxt('./1st_cloud_Sim1/r_stand_div.dat')
#f2=np.loadtxt('./2nd_cloud_Sim1/r_stand_div.dat')
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,2] ,f11[:,1],color=color[1],lw=2,label='$r_d1$')
ax1.plot(f12[:,2] ,f12[:,1],color=color[2],lw=1,label='$r_d2$')
ax1.plot(f13[:,2] ,f13[:,1],color=color[3],lw=1,label='$r_d3$')
ax1.plot(f14[:,2] ,f14[:,1],color=color[4],lw=1,label='$r_d4$')
ax1.plot(f15[:,2] ,f15[:,1],color=color[5],lw=1,label='$r_d5$')
ax1.plot(f16[:,2] ,f16[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d6$')
ax1.plot(f17[:,2] ,f17[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d7$')
#ax1.plot(f1[:,2],f1[:,1],color=color[2],lw=1)#,label='$P$')
ax1.set_xlabel(r"Sd",fontsize=10)
ax1.set_ylabel(r'H(km)',fontsize=12)
ax1.set_title("1st cloud")
ax1.set_xlim([4.5,6.5])
ax1.set_ylim([4,5])
ax1.set_yticks([4,4.2,4.4,4.6,4.8,5])#, -0.1, 0, 0.1, 0.2])
#ax1.set_xticks([14,16,18,20,22,24,26])
#ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f21[:,2] ,f21[:,1],color=color[1],lw=2,label='$r_d$$_1$ = 0.05$\mu$m')
ax2.plot(f22[:,2] ,f22[:,1],color=color[2],lw=1,label='$r_d$$_2$ = 0.07$\mu$m')
ax2.plot(f23[:,2] ,f23[:,1],color=color[3],lw=1,label='$r_d$$_3$ = 0.09$\mu$m')
ax2.plot(f24[:,2] ,f24[:,1],color=color[4],lw=1,label='$r_d$$_4$ = 0.1$\mu$m')
ax2.plot(f25[:,2] ,f25[:,1],color=color[5],lw=1,label='$r_d$$_5$ = 0.5$\mu$m')
ax2.plot(f26[:,2] ,f26[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d$$_6$ = 0.7$\mu$m')
ax2.plot(f27[:,2] ,f27[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d$$_7$ = 0.9$\mu$m')
#ax2.plot(f2[:,2],f2[:,1],color=color[3],lw=1)#,label='$P$')
ax2.set_xlabel(r"Sd",fontsize=10)
ax2.set_ylabel(r'H(km)',fontsize=12)
ax2.set_title("2nd Cloud")
ax2.set_xlim([2,4])
ax2.set_ylim([5.5,6.5])
ax2.set_yticks([5.5,5.7,5.9,6.1,6.3,6.5])#, -0.1, 0, 0.1, 0.2])
#ax2.set_xticks([14,16,18,20,22,24,26])
#ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend1)
plt.legend(bbox_to_anchor=(1.08,1.08), loc='upper left', borderaxespad=0.)
plt.tight_layout()
plt.savefig('Standard_Deviation.png', dpi=300)
plt.show()
plt.close()
####################Height vs Coeff#######################
#-----------------1st cloud--------------------------------
f11=np.loadtxt('./rd1_1st_cld/Kr_Ksi.dat')
f12=np.loadtxt('./rd2_1st_cld/Kr_Ksi.dat')
f13=np.loadtxt('./rd3_1st_cld/Kr_Ksi.dat')
f14=np.loadtxt('./rd4_1st_cld/Kr_Ksi.dat')
f15=np.loadtxt('./rd5_1st_cld/Kr_Ksi.dat')
f16=np.loadtxt('./rd6_1st_cld/Kr_Ksi.dat')
f17=np.loadtxt('./rd7_1st_cld/Kr_Ksi.dat')
#-----------------2nd cloud--------------------------------
f21=np.loadtxt('./rd1_2nd_cld/Kr_Ksi.dat')
f22=np.loadtxt('./rd2_2nd_cld/Kr_Ksi.dat')
f23=np.loadtxt('./rd3_2nd_cld/Kr_Ksi.dat')
f24=np.loadtxt('./rd4_2nd_cld/Kr_Ksi.dat')
f25=np.loadtxt('./rd5_2nd_cld/Kr_Ksi.dat')
f26=np.loadtxt('./rd6_2nd_cld/Kr_Ksi.dat')
f27=np.loadtxt('./rd7_2nd_cld/Kr_Ksi.dat')
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,2] ,f11[:,1],color=color[1],lw=2,label='$r_d1$')
ax1.plot(f12[:,2] ,f12[:,1],color=color[2],lw=1,label='$r_d2$')
ax1.plot(f13[:,2] ,f13[:,1],color=color[3],lw=1,label='$r_d3$')
ax1.plot(f14[:,2] ,f14[:,1],color=color[4],lw=1,label='$r_d4$')
ax1.plot(f15[:,2] ,f15[:,1],color=color[5],lw=1,label='$r_d5$')
ax1.plot(f16[:,2] ,f16[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d6$')
ax1.plot(f17[:,2] ,f17[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d7$')
ax1.set_xlabel(r'$c_m$ (cm/s)',fontsize=14)
ax1.set_ylabel(r'H(Km)',fontsize=14)
#ax1.set_title("1st cloud")
ax1.set_xlim([0,0.0045])
ax1.set_ylim([4,5])
ax1.set_yticks([4,4.2,4.4,4.6,4.8,5.0])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,0.0005,0.001,0.0015,0.002,0.0025,0.003,0.0035,0.004,0.0045])
ax1.ticklabel_format(axis="x", style="sci", scilimits=(-3,-3))
#ax1.set_xticks([283,285,287,289])
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f21[:,2] ,f21[:,1],color=color[1],lw=2,label='$r_d$$_1$ = 0.05$\mu$m')
ax2.plot(f22[:,2] ,f22[:,1],color=color[2],lw=1,label='$r_d$$_2$ = 0.07$\mu$m')
ax2.plot(f23[:,2] ,f23[:,1],color=color[3],lw=1,label='$r_d$$_3$ = 0.09$\mu$m')
ax2.plot(f24[:,2] ,f24[:,1],color=color[4],lw=1,label='$r_d$$_4$ = 0.1$\mu$m')
ax2.plot(f25[:,2] ,f25[:,1],color=color[5],lw=1,label='$r_d$$_5$ = 0.5$\mu$m')
ax2.plot(f26[:,2] ,f26[:,1],color=color[6],lw=1,linestyle='dotted',label='$r_d$$_6$ = 0.7$\mu$m')
ax2.plot(f27[:,2] ,f27[:,1],color=color[7],lw=1,linestyle='dashed',label='$r_d$$_7$ = 0.9$\mu$m')
ax2.set_xlabel(r'$c_m$ (cm/s)',fontsize=14)
ax2.set_ylabel(r'H (Km)',fontsize=14)
#ax2.set_title("2nd Cloud")
ax2.set_xlim([0,0.002])
ax2.set_ylim([5.5,6.5])
ax2.ticklabel_format(axis="x", style="sci", scilimits=(-3,-3))
ax2.set_yticks([5.5,5.7,5.9,6.1,6.3,6.5])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,0.0005,0.001,0.0015,0.002])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend1)
#plt.legend(bbox_to_anchor=(1.08,1.08), loc='upper left', borderaxespad=0.)
plt.tight_layout()
plt.savefig('Hgt_Mean_Coeff.png', dpi=300)
plt.show()
plt.close()
########## Hgt vs Droplet DSD##################################
#################rd1############################################
f11=np.loadtxt('./rd1_1st_cld/DSD/DSD_r_0000001.dat')
f12=np.loadtxt('./rd1_1st_cld/DSD/DSD_r_0800000.dat')
f13=np.loadtxt('./rd1_1st_cld/DSD/DSD_r_1600000.dat')
f14=np.loadtxt('./rd1_1st_cld/DSD/DSD_r_2400000.dat')
f15=np.loadtxt('./rd1_1st_cld/DSD/DSD_r_3150000.dat')
#
f21=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_0000001.dat')
f22=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_0400000.dat')
f23=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_0480000.dat')
f24=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_1200000.dat')
f25=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_2000000.dat')
f26=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_2800000.dat')
f27=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_3600000.dat')
f28=np.loadtxt('./rd1_2nd_cld/DSD/DSD_r_3950000.dat')
#
color=['m','r','b','k','g','orange','c','#f781bf', 'm']
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,0],f11[:,2],color=color[1],lw=1,label='H = 4 km')
ax1.plot(f12[:,0],f12[:,2],color=color[2],lw=1,label='H = 4.2 km')
ax1.plot(f13[:,0],f13[:,2],color=color[3],lw=1,label='H = 4.4 km')
ax1.plot(f14[:,0],f14[:,2],color=color[4],lw=1,label='H = 4.6 km')
ax1.plot(f15[:,0],f15[:,2],color=color[5],lw=1,label='H = 4.8 km',linestyle='dashed')
#ax1.plot(f16[:,0],f16[:,2],color=color[7],lw=1,label='H = 0 km',linestyle='dashed')
ax1.set_ylabel(r"log(PDF)",fontsize=10)
ax1.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax1.set_title("1st cloud")
ax1.set_xlim([0,50])
ax1.set_ylim([0,14])
ax1.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,10,20,30,40,50])
ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
ax2.plot(f21[:,0],f21[:,2],color=color[1],lw=1,label='H = 5.5 km')
ax2.plot(f22[:,0],f22[:,2],color=color[2],lw=1,label='H = 5.6 km')
ax2.plot(f23[:,0],f23[:,2],color=color[3],lw=1,label='H = 5.62 km')
ax2.plot(f24[:,0],f24[:,2],color=color[4],lw=1,label='H = 5.8 km')
ax2.plot(f25[:,0],f25[:,2],color=color[5],lw=1,label='H = 6 km')
ax2.plot(f26[:,0],f26[:,2],color=color[6],lw=1,label='H = 6.2 km',linestyle='dashed')
ax2.plot(f27[:,0],f27[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
#ax2.plot(f28[:,0],f28[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
ax2.set_ylabel(r"log(PDF)",fontsize=10)
ax2.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax2.set_title("2nd Cloud")
ax2.set_xlim([0,50])
ax2.set_ylim([0,14])
ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,10,20,30,40,50])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('rd1_Droplet_DSD.png', dpi=300)
plt.show()
plt.close()
################################################################
#################rd2############################################
f11=np.loadtxt('./rd2_1st_cld/DSD/DSD_r_0000001.dat')
f12=np.loadtxt('./rd2_1st_cld/DSD/DSD_r_0800000.dat')
f13=np.loadtxt('./rd2_1st_cld/DSD/DSD_r_1600000.dat')
f14=np.loadtxt('./rd2_1st_cld/DSD/DSD_r_2400000.dat')
f15=np.loadtxt('./rd2_1st_cld/DSD/DSD_r_3150000.dat')
#
f21=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_0000001.dat')
f22=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_0400000.dat')
f23=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_0480000.dat')
f24=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_1200000.dat')
f25=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_2000000.dat')
f26=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_2800000.dat')
f27=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_3600000.dat')
f28=np.loadtxt('./rd2_2nd_cld/DSD/DSD_r_3950000.dat')
#
color=['m','r','b','k','g','orange','c','#f781bf', 'm']
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,0],f11[:,2],color=color[1],lw=1,label='H = 4 km')
ax1.plot(f12[:,0],f12[:,2],color=color[2],lw=1,label='H = 4.2 km')
ax1.plot(f13[:,0],f13[:,2],color=color[3],lw=1,label='H = 4.4 km')
ax1.plot(f14[:,0],f14[:,2],color=color[4],lw=1,label='H = 4.6 km')
ax1.plot(f15[:,0],f15[:,2],color=color[5],lw=1,label='H = 4.8 km',linestyle='dashed')
#ax1.plot(f16[:,0],f16[:,2],color=color[7],lw=1,label='H = 0 km',linestyle='dashed')
ax1.set_ylabel(r"log(PDF)",fontsize=10)
ax1.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax1.set_title("1st cloud")
ax1.set_xlim([0,50])
ax1.set_ylim([0,14])
ax1.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,10,20,30,40,50])
ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
#
ax2.plot(f21[:,0],f21[:,2],color=color[1],lw=1,label='H = 5.5 km')
ax2.plot(f22[:,0],f22[:,2],color=color[2],lw=1,label='H = 5.6 km')
ax2.plot(f23[:,0],f23[:,2],color=color[3],lw=1,label='H = 5.62 km')
ax2.plot(f24[:,0],f24[:,2],color=color[4],lw=1,label='H = 5.8 km')
ax2.plot(f25[:,0],f25[:,2],color=color[5],lw=1,label='H = 6 km')
ax2.plot(f26[:,0],f26[:,2],color=color[6],lw=1,label='H = 6.2 km',linestyle='dashed')
ax2.plot(f27[:,0],f27[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
ax2.set_ylabel(r"log(PDF)",fontsize=10)
ax2.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax2.set_title("2nd Cloud")
ax2.set_xlim([0,50])
ax2.set_ylim([0,14])
ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,10,20,30,40,50])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('rd2_Droplet_DSD.png', dpi=300)
plt.show()
plt.close()
################################################################
#################rd3############################################
f11=np.loadtxt('./rd3_1st_cld/DSD/DSD_r_0000001.dat')
f16=np.loadtxt('./rd3_1st_cld/DSD/DSD_r_0050000.dat')
f12=np.loadtxt('./rd3_1st_cld/DSD/DSD_r_0800000.dat')
f13=np.loadtxt('./rd3_1st_cld/DSD/DSD_r_1600000.dat')
f14=np.loadtxt('./rd3_1st_cld/DSD/DSD_r_2400000.dat')
f15=np.loadtxt('./rd3_1st_cld/DSD/DSD_r_3150000.dat')
f15=np.loadtxt('./rd3_1st_cld/DSD/DSD_r_4000000.dat')
#
f21=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_0000001.dat')
f28=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_0050000.dat')
f22=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_0480000.dat')
f23=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_1200000.dat')
f24=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_2000000.dat')
f25=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_2800000.dat')
f26=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_3600000.dat')
f27=np.loadtxt('./rd3_2nd_cld/DSD/DSD_r_3950000.dat')
#
color=['m','r','b','k','g','orange','c','#f781bf', 'm']
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,0],f11[:,2],color=color[1],lw=1,label='H = 4 km')
ax1.plot(f16[:,0],f16[:,2],color=color[8],lw=1,label='H = 4.012 km')
ax1.plot(f12[:,0],f12[:,2],color=color[2],lw=1,label='H = 4.2 km')
ax1.plot(f13[:,0],f13[:,2],color=color[3],lw=1,label='H = 4.4 km')
ax1.plot(f14[:,0],f14[:,2],color=color[4],lw=1,label='H = 4.6 km')
ax1.plot(f15[:,0],f15[:,2],color=color[5],lw=1,label='H = 4.8 km',linestyle='dashed')
ax1.plot(f16[:,0],f16[:,2],color=color[7],lw=1,label='H = 5.0 km',linestyle='dashed')
ax1.set_ylabel(r"DSD",fontsize=12)
ax1.set_xlabel(r'D( $\mu$m)',fontsize=12)
#ax1.set_title("1st cloud")
ax1.set_xlim([0,50])
ax1.set_ylim([0,14])
ax1.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,10,20,30,40,50])
ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
#
ax2.plot(f21[:,0],f21[:,2],color=color[1],lw=1,label='H = 5.5 km')
ax2.plot(f28[:,0],f28[:,2],color=color[2],lw=1,label='H = 5.512 km')
ax2.plot(f23[:,0],f23[:,2],color=color[3],lw=1,label='H = 5.62 km')
ax2.plot(f24[:,0],f24[:,2],color=color[4],lw=1,label='H = 5.8 km')
ax2.plot(f25[:,0],f25[:,2],color=color[5],lw=1,label='H = 6 km')
ax2.plot(f26[:,0],f26[:,2],color=color[6],lw=1,label='H = 6.2 km',linestyle='dashed')
ax2.plot(f27[:,0],f27[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
ax2.set_ylabel(r"DSD",fontsize=12)
ax2.set_xlabel(r'D( $\mu$m)',fontsize=12)
#ax2.set_title("2nd Cloud")
ax2.set_xlim([0,50])
ax2.set_ylim([0,14])
ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,10,20,30,40,50])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('New_rd3_Droplet_DSD.png', dpi=300)
plt.show()
plt.close()
################################################################
#################rd4############################################
f11=np.loadtxt('./rd4_1st_cld/DSD/DSD_r_0000001.dat')
f12=np.loadtxt('./rd4_1st_cld/DSD/DSD_r_0800000.dat')
f13=np.loadtxt('./rd4_1st_cld/DSD/DSD_r_1600000.dat')
f14=np.loadtxt('./rd4_1st_cld/DSD/DSD_r_2400000.dat')
f15=np.loadtxt('./rd4_1st_cld/DSD/DSD_r_3150000.dat')
#
f21=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_0000001.dat')
f22=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_0400000.dat')
f23=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_0480000.dat')
f24=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_1200000.dat')
f25=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_2000000.dat')
f26=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_2800000.dat')
f27=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_3600000.dat')
f27=np.loadtxt('./rd4_2nd_cld/DSD/DSD_r_3950000.dat')
#
color=['m','r','b','k','g','orange','c','#f781bf', 'm']
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,0],f11[:,2],color=color[1],lw=1,label='H = 4 km')
ax1.plot(f12[:,0],f12[:,2],color=color[2],lw=1,label='H = 4.2 km')
ax1.plot(f13[:,0],f13[:,2],color=color[3],lw=1,label='H = 4.4 km')
ax1.plot(f14[:,0],f14[:,2],color=color[4],lw=1,label='H = 4.6 km')
ax1.plot(f15[:,0],f15[:,2],color=color[5],lw=1,label='H = 4.8 km',linestyle='dashed')
#ax1.plot(f16[:,0],f16[:,2],color=color[7],lw=1,label='H = 0 km',linestyle='dashed')
ax1.set_ylabel(r"log(PDF)",fontsize=10)
ax1.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax1.set_title("1st cloud")
ax1.set_xlim([0,50])
ax1.set_ylim([0,14])
ax1.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,10,20,30,40,50])
ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
#
ax2.plot(f21[:,0],f21[:,2],color=color[1],lw=1,label='H = 5.5 km')
ax2.plot(f22[:,0],f22[:,2],color=color[2],lw=1,label='H = 5.6 km')
ax2.plot(f23[:,0],f23[:,2],color=color[3],lw=1,label='H = 5.62 km')
ax2.plot(f24[:,0],f24[:,2],color=color[4],lw=1,label='H = 5.8 km')
ax2.plot(f25[:,0],f25[:,2],color=color[5],lw=1,label='H = 6 km')
ax2.plot(f26[:,0],f26[:,2],color=color[6],lw=1,label='H = 6.2 km',linestyle='dashed')
ax2.plot(f27[:,0],f27[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
ax2.set_ylabel(r"log(PDF)",fontsize=10)
ax2.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax2.set_title("2nd Cloud")
ax2.set_xlim([0,50])
ax2.set_ylim([0,14])
ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,10,20,30,40,50])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('rd4_Droplet_DSD.png', dpi=300)
plt.show()
plt.close()
################################################################
#################rd5############################################
f11=np.loadtxt('./rd5_1st_cld/DSD/DSD_r_0000001.dat')
f12=np.loadtxt('./rd5_1st_cld/DSD/DSD_r_0800000.dat')
f13=np.loadtxt('./rd5_1st_cld/DSD/DSD_r_1600000.dat')
f14=np.loadtxt('./rd5_1st_cld/DSD/DSD_r_2400000.dat')
f15=np.loadtxt('./rd5_1st_cld/DSD/DSD_r_3150000.dat')
#
f21=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_0000001.dat')
f22=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_0400000.dat')
f23=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_0480000.dat')
f24=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_1200000.dat')
f25=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_2000000.dat')
f26=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_2800000.dat')
f27=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_3600000.dat')
f27=np.loadtxt('./rd5_2nd_cld/DSD/DSD_r_3950000.dat')
#
color=['m','r','b','k','g','orange','c','#f781bf', 'm']
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,0],f11[:,2],color=color[1],lw=1,label='H = 4 km')
ax1.plot(f12[:,0],f12[:,2],color=color[2],lw=1,label='H = 4.2 km')
ax1.plot(f13[:,0],f13[:,2],color=color[3],lw=1,label='H = 4.4 km')
ax1.plot(f14[:,0],f14[:,2],color=color[4],lw=1,label='H = 4.6 km')
ax1.plot(f15[:,0],f15[:,2],color=color[5],lw=1,label='H = 4.8 km',linestyle='dashed')
#ax1.plot(f16[:,0],f16[:,2],color=color[7],lw=1,label='H = 0 km',linestyle='dashed')
ax1.set_ylabel(r"log(PDF)",fontsize=10)
ax1.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax1.set_title("1st cloud")
ax1.set_xlim([0,50])
ax1.set_ylim([0,14])
ax1.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,10,20,30,40,50])
ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
#
ax2.plot(f21[:,0],f21[:,2],color=color[1],lw=1,label='H = 5.5 km')
ax2.plot(f22[:,0],f22[:,2],color=color[2],lw=1,label='H = 5.6 km')
ax2.plot(f23[:,0],f23[:,2],color=color[3],lw=1,label='H = 5.62 km')
ax2.plot(f24[:,0],f24[:,2],color=color[4],lw=1,label='H = 5.8 km')
ax2.plot(f25[:,0],f25[:,2],color=color[5],lw=1,label='H = 6 km')
ax2.plot(f26[:,0],f26[:,2],color=color[6],lw=1,label='H = 6.2 km',linestyle='dashed')
ax2.plot(f27[:,0],f27[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
ax2.set_ylabel(r"log(PDF)",fontsize=10)
ax2.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax2.set_title("2nd Cloud")
ax2.set_xlim([0,50])
ax2.set_ylim([0,14])
ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,10,20,30,40,50])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('rd5_Droplet_DSD.png', dpi=300)
plt.show()
plt.close()
################################################################
#################rd6############################################
f11=np.loadtxt('./rd6_1st_cld/DSD/DSD_r_0000001.dat')
f12=np.loadtxt('./rd6_1st_cld/DSD/DSD_r_0800000.dat')
f13=np.loadtxt('./rd6_1st_cld/DSD/DSD_r_1600000.dat')
f14=np.loadtxt('./rd6_1st_cld/DSD/DSD_r_2400000.dat')
f15=np.loadtxt('./rd6_1st_cld/DSD/DSD_r_3150000.dat')
#
f21=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_0000001.dat')
f22=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_0400000.dat')
f23=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_0480000.dat')
f24=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_1200000.dat')
f25=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_2000000.dat')
f26=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_2800000.dat')
f27=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_3600000.dat')
f27=np.loadtxt('./rd6_2nd_cld/DSD/DSD_r_3950000.dat')
#
color=['m','r','b','k','g','orange','c','#f781bf', 'm']
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,0],f11[:,2],color=color[1],lw=1,label='H = 4 km')
ax1.plot(f12[:,0],f12[:,2],color=color[2],lw=1,label='H = 4.2 km')
ax1.plot(f13[:,0],f13[:,2],color=color[3],lw=1,label='H = 4.4 km')
ax1.plot(f14[:,0],f14[:,2],color=color[4],lw=1,label='H = 4.6 km')
ax1.plot(f15[:,0],f15[:,2],color=color[5],lw=1,label='H = 4.8 km',linestyle='dashed')
#ax1.plot(f16[:,0],f16[:,2],color=color[7],lw=1,label='H = 0 km',linestyle='dashed')
ax1.set_ylabel(r"log(PDF)",fontsize=10)
ax1.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax1.set_title("1st cloud")
ax1.set_xlim([0,50])
ax1.set_ylim([0,14])
ax1.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,10,20,30,40,50])
ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
#
ax2.plot(f21[:,0],f21[:,2],color=color[1],lw=1,label='H = 5.5 km')
ax2.plot(f22[:,0],f22[:,2],color=color[2],lw=1,label='H = 5.6 km')
ax2.plot(f23[:,0],f23[:,2],color=color[3],lw=1,label='H = 5.62 km')
ax2.plot(f24[:,0],f24[:,2],color=color[4],lw=1,label='H = 5.8 km')
ax2.plot(f25[:,0],f25[:,2],color=color[5],lw=1,label='H = 6 km')
ax2.plot(f26[:,0],f26[:,2],color=color[6],lw=1,label='H = 6.2 km',linestyle='dashed')
ax2.plot(f27[:,0],f27[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
ax2.set_ylabel(r"log(PDF)",fontsize=10)
ax2.set_xlabel(r'D( $\mu$m)',fontsize=12)
ax2.set_title("2nd Cloud")
ax2.set_xlim([0,50])
ax2.set_ylim([0,14])
ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,10,20,30,40,50])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('rd6_Droplet_DSD.png', dpi=300)
plt.show()
plt.close()
################################################################
#################rd7############################################
f11=np.loadtxt('./rd7_1st_cld/DSD/DSD_r_0000001.dat')
f12=np.loadtxt('./rd7_1st_cld/DSD/DSD_r_0800000.dat')
f13=np.loadtxt('./rd7_1st_cld/DSD/DSD_r_1600000.dat')
f14=np.loadtxt('./rd7_1st_cld/DSD/DSD_r_2400000.dat')
f15=np.loadtxt('./rd7_1st_cld/DSD/DSD_r_3150000.dat')
#
f21=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_0000001.dat')
f22=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_0400000.dat')
f23=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_0480000.dat')
f24=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_1200000.dat')
f25=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_2000000.dat')
f26=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_2800000.dat')
#f27=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_3600000.dat')
#f28=np.loadtxt('./rd7_2nd_cld/DSD/DSD_r_3950000.dat')
#
color=['m','r','b','k','g','orange','c','#f781bf', 'm']
#
fig, (ax1, ax2) = plt.subplots(1, 2, figsize= (10,3))
#
ax1.plot(f11[:,0],f11[:,2],color=color[1],lw=1,label='H = 4 km')
ax1.plot(f12[:,0],f12[:,2],color=color[2],lw=1,label='H = 4.2 km')
ax1.plot(f13[:,0],f13[:,2],color=color[3],lw=1,label='H = 4.4 km')
ax1.plot(f14[:,0],f14[:,2],color=color[4],lw=1,label='H = 4.6 km')
ax1.plot(f15[:,0],f15[:,2],color=color[5],lw=1,label='H = 4.8 km',linestyle='dashed')
#ax1.plot(f16[:,0],f16[:,2],color=color[7],lw=1,label='H = 0 km',linestyle='dashed')
ax1.set_ylabel(r"log(PDF)",fontsize=10)
ax1.set_xlabel(r'D($\mu$m)',fontsize=12)
ax1.set_title("1st cloud")
ax1.set_xlim([0,50])
ax1.set_ylim([0,14])
ax1.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax1.set_xticks([0,10,20,30,40,50])
ax1.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax1.xaxis.set_tick_params(labelsize=11)
ax1.yaxis.set_tick_params(labelsize=11)
ax1.grid()
#
#
ax2.plot(f21[:,0],f21[:,2],color=color[1],lw=1,label='H = 5.5 km')
ax2.plot(f22[:,0],f22[:,2],color=color[2],lw=1,label='H = 5.6 km')
ax2.plot(f23[:,0],f23[:,2],color=color[3],lw=1,label='H = 5.62 km')
ax2.plot(f24[:,0],f24[:,2],color=color[4],lw=1,label='H = 5.8 km')
ax2.plot(f25[:,0],f25[:,2],color=color[5],lw=1,label='H = 6 km')
ax2.plot(f26[:,0],f26[:,2],color=color[6],lw=1,label='H = 6.2 km',linestyle='dashed')
#ax2.plot(f27[:,0],f27[:,2],color=color[7],lw=2,label='H = 6.4 km',linestyle=':')
ax2.set_ylabel(r"log(PDF)",fontsize=10)
ax2.set_xlabel(r'D($\mu$m)',fontsize=12)
ax2.set_title("2nd Cloud")
ax2.set_xlim([0,50])
ax2.set_ylim([0,14])
ax2.legend(loc='upper right',prop={'size':6.5},frameon=False)
ax2.set_yticks([0,2,4,6,8,10,12,14])#, -0.1, 0, 0.1, 0.2])
ax2.set_xticks([0,10,20,30,40,50])
ax2.xaxis.set_tick_params(labelsize=11)
ax2.yaxis.set_tick_params(labelsize=11)
ax2.grid()
#
#plt.grid()
#plt.gca().add_artist(legend)
plt.tight_layout()
plt.savefig('rd7_Droplet_DSD.png', dpi=300)
plt.show()
plt.close()
################################################################

